/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanSanityChecker;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final ConnectorSession session;
    private final List<PlanOptimizer> planOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;

    public LogicalPlanner(ConnectorSession session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata) {
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.session = session;
        this.planOptimizers = planOptimizers;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public Plan plan(Analysis analysis) {
        RelationPlan plan = analysis.getCreateTableDestination().isPresent() ? this.createTableCreationPlan(analysis) : (analysis.getInsertTarget().isPresent() ? this.createInsertPlan(analysis) : this.createRelationPlan(analysis));
        PlanNode root = this.createOutputPlan(plan, analysis);
        PlanSanityChecker.validate(root);
        for (PlanOptimizer optimizer : this.planOptimizers) {
            root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator);
        }
        PlanSanityChecker.validate(root);
        return new Plan(root, this.symbolAllocator);
    }

    private RelationPlan createTableCreationPlan(Analysis analysis) {
        QualifiedTableName destination = (QualifiedTableName)analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis);
        TableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan), plan.getSampleWeight().isPresent());
        Preconditions.checkState((!plan.getSampleWeight().isPresent() || this.metadata.canCreateSampledTables(this.session, destination.getCatalogName()) ? 1 : 0) != 0, (Object)"Cannot write sampled data to a store that doesn't support sampling");
        return this.createTableWriterPlan(analysis, plan, tableMetadata, new TableWriterNode.CreateName(destination.getCatalogName(), tableMetadata));
    }

    private RelationPlan createInsertPlan(Analysis analysis) {
        TableHandle target = (TableHandle)analysis.getInsertTarget().get();
        return this.createTableWriterPlan(analysis, this.createRelationPlan(analysis), this.metadata.getTableMetadata(target), new TableWriterNode.InsertReference(target));
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableMetadata tableMetadata, TableWriterNode.WriterTarget target) {
        ImmutableList writerOutputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarcharType.VARCHAR));
        TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), plan.getRoot(), target, plan.getOutputSymbols(), LogicalPlanner.getColumnNames(tableMetadata), (List<Symbol>)writerOutputs, plan.getSampleWeight());
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableCommitNode commitNode = new TableCommitNode(this.idAllocator.getNextId(), writerNode, target, (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getOutputDescriptor(), (List<Symbol>)outputs, (Optional<Symbol>)Optional.absent());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        TupleDescriptor outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = (String)field.getName().or((Object)("_col" + columnNumber));
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis) {
        return (RelationPlan)new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)analysis.getQuery(), null);
    }

    private TableMetadata createTableMetadata(QualifiedTableName table, List<ColumnMetadata> columns, boolean sampled) {
        String owner = this.session.getUser();
        ConnectorTableMetadata metadata = new ConnectorTableMetadata(table.asSchemaTableName(), columns, owner, sampled);
        return new TableMetadata(table.getCatalogName(), metadata);
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int ordinalPosition = 0;
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            columns.add((Object)new ColumnMetadata((String)field.getName().get(), field.getType(), ordinalPosition, false));
            ++ordinalPosition;
        }
        return columns.build();
    }

    private static List<String> getColumnNames(TableMetadata tableMetadata) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            list.add((Object)column.getName());
        }
        return list.build();
    }
}

