/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.IdentityHashMap;
import java.util.Map;

public class InterpretedProjectionFunction
implements ProjectionFunction {
    private final Type type;
    private final ExpressionInterpreter evaluator;

    public InterpretedProjectionFunction(Expression expression, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, ConnectorSession session) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(symbolToInputMappings), (Expression)expression);
        ImmutableMap.Builder inputTypes = ImmutableMap.builder();
        for (Map.Entry<Symbol, Integer> entry : symbolToInputMappings.entrySet()) {
            inputTypes.put((Object)entry.getValue(), (Object)symbolTypes.get(entry.getKey()));
        }
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, (Map<Integer, Type>)inputTypes.build(), rewritten);
        this.type = (Type)Preconditions.checkNotNull((Object)expressionTypes.get(rewritten), (Object)"type is null");
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session, expressionTypes);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void project(int position, Block[] blocks, BlockBuilder output) {
        Object value = this.evaluator.evaluate(position, blocks);
        this.append(output, value);
    }

    @Override
    public void project(RecordCursor cursor, BlockBuilder output) {
        Object value = this.evaluator.evaluate(cursor);
        this.append(output, value);
    }

    private void append(BlockBuilder output, Object value) {
        if (value == null) {
            output.appendNull();
            return;
        }
        Class javaType = this.type.getJavaType();
        if (javaType == Boolean.TYPE) {
            this.type.writeBoolean(output, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            this.type.writeLong(output, ((Long)value).longValue());
        } else if (javaType == Double.TYPE) {
            this.type.writeDouble(output, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = (Slice)value;
            this.type.writeSlice(output, slice, 0, slice.length());
        } else {
            throw new UnsupportedOperationException("not yet implemented: " + this.type);
        }
    }
}

