/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SubPlanBuilder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberLimitNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DistributedLogicalPlanner {
    private final ConnectorSession session;
    private final Metadata metadata;
    private final PlanNodeIdAllocator idAllocator;

    public DistributedLogicalPlanner(ConnectorSession session, Metadata metadata, PlanNodeIdAllocator idAllocator) {
        this.session = (ConnectorSession)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
    }

    public SubPlan createSubPlans(Plan plan, boolean createSingleNodePlan, boolean distributedIndexJoins) {
        Visitor visitor = new Visitor(plan.getSymbolAllocator(), createSingleNodePlan, distributedIndexJoins);
        SubPlanBuilder builder = plan.getRoot().accept(visitor, null);
        SubPlan subplan = builder.build();
        subplan.sanityCheck();
        return subplan;
    }

    private class Visitor
    extends PlanVisitor<Void, SubPlanBuilder> {
        private int nextFragmentId = 0;
        private final SymbolAllocator allocator;
        private final boolean createSingleNodePlan;
        private final boolean distributedIndexJoins;

        public Visitor(SymbolAllocator allocator, boolean createSingleNodePlan, boolean distributedIndexJoins) {
            this.allocator = allocator;
            this.createSingleNodePlan = createSingleNodePlan;
            this.distributedIndexJoins = distributedIndexJoins;
        }

        @Override
        public SubPlanBuilder visitAggregation(AggregationNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            if (!current.isDistributed()) {
                current.setRoot(new AggregationNode(node.getId(), current.getRoot(), node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), AggregationNode.Step.SINGLE, node.getSampleWeight(), node.getConfidence()));
                return current;
            }
            Map<Symbol, FunctionCall> aggregations = node.getAggregations();
            Map<Symbol, Signature> functions = node.getFunctions();
            Map<Symbol, Symbol> masks = node.getMasks();
            List<Symbol> groupBy = node.getGroupBy();
            boolean decomposable = true;
            for (Signature function : functions.values()) {
                if (DistributedLogicalPlanner.this.metadata.getExactFunction(function).getAggregationFunction().isDecomposable()) continue;
                decomposable = false;
                break;
            }
            if (decomposable) {
                return this.addDistributedAggregation(current, aggregations, functions, masks, groupBy, node.getSampleWeight(), node.getConfidence());
            }
            return this.addSingleNodeAggregation(current, aggregations, functions, masks, groupBy, node.getSampleWeight(), node.getConfidence());
        }

        @Override
        public SubPlanBuilder visitMarkDistinct(MarkDistinctNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            boolean alreadyPartitioned = false;
            if (current.getDistribution() == PlanFragment.PlanDistribution.FIXED) {
                for (SubPlan child : current.getChildren()) {
                    if (child.getFragment().getOutputPartitioning() != PlanFragment.OutputPartitioning.HASH || !ImmutableSet.copyOf(child.getFragment().getPartitionBy()).equals((Object)ImmutableSet.copyOf(node.getDistinctSymbols()))) continue;
                    alreadyPartitioned = true;
                    break;
                }
            }
            if (this.createSingleNodePlan || alreadyPartitioned || !current.isDistributed()) {
                MarkDistinctNode markNode = new MarkDistinctNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), node.getMarkerSymbol(), node.getDistinctSymbols());
                current.setRoot(markNode);
                return current;
            }
            SinkNode sink = new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols());
            current.setRoot(sink).setHashOutputPartitioning(node.getDistinctSymbols());
            ExchangeNode exchange = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), ((PlanNode)sink).getOutputSymbols());
            MarkDistinctNode markNode = new MarkDistinctNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), exchange, node.getMarkerSymbol(), node.getDistinctSymbols());
            return this.createFixedDistributionPlan(markNode).addChild(current.build());
        }

        private SubPlanBuilder addSingleNodeAggregation(SubPlanBuilder plan, Map<Symbol, FunctionCall> aggregations, Map<Symbol, Signature> functions, Map<Symbol, Symbol> masks, List<Symbol> groupBy, Optional<Symbol> sampleWeight, double confidence) {
            plan.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), plan.getRoot(), plan.getRoot().getOutputSymbols()));
            ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), plan.getId(), plan.getRoot().getOutputSymbols());
            AggregationNode aggregation = new AggregationNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), source, groupBy, aggregations, functions, masks, AggregationNode.Step.SINGLE, sampleWeight, confidence);
            plan = this.createSingleNodePlan(aggregation).addChild(plan.build());
            return plan;
        }

        private SubPlanBuilder addDistributedAggregation(SubPlanBuilder plan, Map<Symbol, FunctionCall> aggregations, Map<Symbol, Signature> functions, Map<Symbol, Symbol> masks, List<Symbol> groupBy, Optional<Symbol> sampleWeight, double confidence) {
            HashMap<Symbol, FunctionCall> finalCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, FunctionCall> intermediateCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, Signature> intermediateFunctions = new HashMap<Symbol, Signature>();
            HashMap<Symbol, Symbol> intermediateMask = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : aggregations.entrySet()) {
                Signature signature = functions.get(entry.getKey());
                FunctionInfo function = DistributedLogicalPlanner.this.metadata.getExactFunction(signature);
                Symbol intermediateSymbol = this.allocator.newSymbol(function.getName().getSuffix(), DistributedLogicalPlanner.this.metadata.getType(function.getIntermediateType()));
                intermediateCalls.put(intermediateSymbol, entry.getValue());
                intermediateFunctions.put(intermediateSymbol, signature);
                if (masks.containsKey(entry.getKey())) {
                    intermediateMask.put(intermediateSymbol, masks.get(entry.getKey()));
                }
                finalCalls.put(entry.getKey(), new FunctionCall(function.getName(), (List)ImmutableList.of((Object)new QualifiedNameReference(intermediateSymbol.toQualifiedName()))));
            }
            AggregationNode partialAggregation = new AggregationNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), plan.getRoot(), groupBy, intermediateCalls, intermediateFunctions, intermediateMask, AggregationNode.Step.PARTIAL, sampleWeight, confidence);
            plan.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), partialAggregation, partialAggregation.getOutputSymbols()));
            ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), plan.getId(), plan.getRoot().getOutputSymbols());
            AggregationNode finalAggregation = new AggregationNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), source, groupBy, finalCalls, functions, (Map<Symbol, Symbol>)ImmutableMap.of(), AggregationNode.Step.FINAL, (Optional<Symbol>)Optional.absent(), confidence);
            if (groupBy.isEmpty()) {
                plan = this.createSingleNodePlan(finalAggregation).addChild(plan.build());
            } else {
                plan.setHashOutputPartitioning(groupBy);
                plan = this.createFixedDistributionPlan(finalAggregation).addChild(plan.build());
            }
            return plan;
        }

        @Override
        public SubPlanBuilder visitWindow(WindowNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            if (current.isDistributed()) {
                List<Symbol> partitionedBy = node.getPartitionBy();
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols());
                if (partitionedBy.isEmpty()) {
                    current = this.createSingleNodePlan(source).addChild(current.build());
                } else {
                    current.setHashOutputPartitioning(partitionedBy);
                    current = this.createFixedDistributionPlan(source).addChild(current.build());
                }
            }
            current.setRoot(new WindowNode(node.getId(), current.getRoot(), node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getWindowFunctions(), node.getSignatures()));
            return current;
        }

        @Override
        public SubPlanBuilder visitRowNumberLimit(RowNumberLimitNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            if (current.isDistributed()) {
                List<Symbol> partitionedBy = node.getPartitionBy();
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols());
                current.setHashOutputPartitioning(partitionedBy);
                current = this.createFixedDistributionPlan(source).addChild(current.build());
            }
            current.setRoot(new RowNumberLimitNode(node.getId(), current.getRoot(), node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition()));
            return current;
        }

        @Override
        public SubPlanBuilder visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            if (current.isDistributed()) {
                List<Symbol> partitionedBy = node.getPartitionBy();
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols());
                current.setHashOutputPartitioning(partitionedBy);
                current = this.createFixedDistributionPlan(source).addChild(current.build());
            }
            current.setRoot(new TopNRowNumberNode(node.getId(), current.getRoot(), node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition()));
            return current;
        }

        @Override
        public SubPlanBuilder visitFilter(FilterNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            current.setRoot(new FilterNode(node.getId(), current.getRoot(), node.getPredicate()));
            return current;
        }

        @Override
        public SubPlanBuilder visitSample(SampleNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            current.setRoot(new SampleNode(node.getId(), current.getRoot(), node.getSampleRatio(), node.getSampleType(), node.isRescaled(), node.getSampleWeightSymbol()));
            return current;
        }

        @Override
        public SubPlanBuilder visitProject(ProjectNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            current.setRoot(new ProjectNode(node.getId(), current.getRoot(), node.getOutputMap()));
            return current;
        }

        @Override
        public SubPlanBuilder visitTopN(TopNNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            boolean partial = current.isDistributed();
            current.setRoot(new TopNNode(node.getId(), current.getRoot(), node.getCount(), node.getOrderBy(), node.getOrderings(), partial));
            if (current.isDistributed()) {
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols());
                TopNNode merge = new TopNNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), source, node.getCount(), node.getOrderBy(), node.getOrderings(), false);
                current = this.createSingleNodePlan(merge).addChild(current.build());
            }
            return current;
        }

        @Override
        public SubPlanBuilder visitSort(SortNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            if (current.isDistributed()) {
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                current = this.createSingleNodePlan(new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols())).addChild(current.build());
            }
            current.setRoot(new SortNode(node.getId(), current.getRoot(), node.getOrderBy(), node.getOrderings()));
            return current;
        }

        @Override
        public SubPlanBuilder visitOutput(OutputNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            if (current.isDistributed()) {
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                current = this.createSingleNodePlan(new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols())).addChild(current.build());
            }
            current.setRoot(new OutputNode(node.getId(), current.getRoot(), node.getColumnNames(), node.getOutputSymbols()));
            return current;
        }

        @Override
        public SubPlanBuilder visitLimit(LimitNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            current.setRoot(new LimitNode(node.getId(), current.getRoot(), node.getCount()));
            if (current.isDistributed()) {
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols());
                LimitNode merge = new LimitNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), source, node.getCount());
                current = this.createSingleNodePlan(merge).addChild(current.build());
            }
            return current;
        }

        @Override
        public SubPlanBuilder visitDistinctLimit(DistinctLimitNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            current.setRoot(new DistinctLimitNode(node.getId(), current.getRoot(), node.getLimit()));
            if (current.isDistributed()) {
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                ExchangeNode source = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols());
                DistinctLimitNode merge = new DistinctLimitNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), source, node.getLimit());
                current = this.createSingleNodePlan(merge).addChild(current.build());
            }
            return current;
        }

        @Override
        public SubPlanBuilder visitTableScan(TableScanNode node, Void context) {
            return this.createSourceDistributionPlan(node, node.getId());
        }

        @Override
        public SubPlanBuilder visitValues(ValuesNode node, Void context) {
            return this.createSingleNodePlan(node);
        }

        @Override
        public SubPlanBuilder visitTableWriter(TableWriterNode node, Void context) {
            TableWriterNode.WriterTarget target = this.createWriterTarget(node.getTarget());
            SubPlanBuilder current = node.getSource().accept(this, context);
            current.setRoot(new TableWriterNode(node.getId(), current.getRoot(), target, node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getSampleWeightSymbol()));
            return current;
        }

        private TableWriterNode.WriterTarget createWriterTarget(TableWriterNode.WriterTarget target) {
            if (target instanceof TableWriterNode.CreateName) {
                TableWriterNode.CreateName create = (TableWriterNode.CreateName)target;
                return new TableWriterNode.CreateHandle(DistributedLogicalPlanner.this.metadata.beginCreateTable(DistributedLogicalPlanner.this.session, create.getCatalog(), create.getTableMetadata()));
            }
            if (target instanceof TableWriterNode.InsertReference) {
                TableWriterNode.InsertReference insert = (TableWriterNode.InsertReference)target;
                return new TableWriterNode.InsertHandle(DistributedLogicalPlanner.this.metadata.beginInsert(DistributedLogicalPlanner.this.session, insert.getHandle()));
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        }

        @Override
        public SubPlanBuilder visitTableCommit(TableCommitNode node, Void context) {
            SubPlanBuilder current = node.getSource().accept(this, context);
            Preconditions.checkState((boolean)(current.getRoot() instanceof TableWriterNode), (Object)"table commit node must be preceeded by table writer node");
            TableWriterNode.WriterTarget target = ((TableWriterNode)current.getRoot()).getTarget();
            if (current.getDistribution() != PlanFragment.PlanDistribution.COORDINATOR_ONLY && !this.createSingleNodePlan) {
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols()));
                current = this.createCoordinatorOnlyPlan(new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), current.getRoot().getOutputSymbols())).addChild(current.build());
            }
            current.setRoot(new TableCommitNode(node.getId(), current.getRoot(), target, node.getOutputSymbols()));
            return current;
        }

        @Override
        public SubPlanBuilder visitJoin(JoinNode node, Void context) {
            SubPlanBuilder left = node.getLeft().accept(this, context);
            SubPlanBuilder right = node.getRight().accept(this, context);
            if (left.isDistributed() || right.isDistributed()) {
                switch (node.getType()) {
                    case INNER: 
                    case LEFT: {
                        right.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), right.getRoot(), right.getRoot().getOutputSymbols()));
                        left.setRoot(new JoinNode(node.getId(), node.getType(), left.getRoot(), new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), right.getId(), right.getRoot().getOutputSymbols()), node.getCriteria()));
                        left.addChild(right.build());
                        return left;
                    }
                    case RIGHT: {
                        left.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), left.getRoot(), left.getRoot().getOutputSymbols()));
                        right.setRoot(new JoinNode(node.getId(), node.getType(), new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), left.getId(), left.getRoot().getOutputSymbols()), right.getRoot(), node.getCriteria()));
                        right.addChild(left.build());
                        return right;
                    }
                }
                throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
            }
            JoinNode join = new JoinNode(node.getId(), node.getType(), left.getRoot(), right.getRoot(), node.getCriteria());
            return this.createSingleNodePlan(join).setChildren(Iterables.concat(left.getChildren(), right.getChildren()));
        }

        @Override
        public SubPlanBuilder visitSemiJoin(SemiJoinNode node, Void context) {
            SubPlanBuilder source = node.getSource().accept(this, context);
            SubPlanBuilder filteringSource = node.getFilteringSource().accept(this, context);
            if (source.isDistributed() || filteringSource.isDistributed()) {
                filteringSource.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), filteringSource.getRoot(), filteringSource.getRoot().getOutputSymbols()));
                source.setRoot(new SemiJoinNode(node.getId(), source.getRoot(), new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), filteringSource.getId(), filteringSource.getRoot().getOutputSymbols()), node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput()));
                source.addChild(filteringSource.build());
                return source;
            }
            SemiJoinNode semiJoinNode = new SemiJoinNode(node.getId(), source.getRoot(), filteringSource.getRoot(), node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
            return this.createSingleNodePlan(semiJoinNode).setChildren(Iterables.concat(source.getChildren(), filteringSource.getChildren()));
        }

        @Override
        public SubPlanBuilder visitIndexJoin(IndexJoinNode node, Void context) {
            SubPlanBuilder current = node.getProbeSource().accept(this, context);
            if (this.distributedIndexJoins && current.isDistributed()) {
                SinkNode sink = new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), current.getRoot().getOutputSymbols());
                current.setRoot(sink).setHashOutputPartitioning(Lists.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause.probeGetter()));
                ExchangeNode exchange = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getId(), ((PlanNode)sink).getOutputSymbols());
                return this.createFixedDistributionPlan(new IndexJoinNode(node.getId(), node.getType(), exchange, node.getIndexSource(), node.getCriteria())).addChild(current.build());
            }
            current.setRoot(new IndexJoinNode(node.getId(), node.getType(), current.getRoot(), node.getIndexSource(), node.getCriteria()));
            return current;
        }

        @Override
        public SubPlanBuilder visitUnion(UnionNode node, Void context) {
            if (this.createSingleNodePlan) {
                ImmutableList.Builder sourceBuilder = ImmutableList.builder();
                for (PlanNode source : node.getSources()) {
                    sourceBuilder.add((Object)source.accept(this, context).getRoot());
                }
                UnionNode unionNode = new UnionNode(node.getId(), (List<PlanNode>)sourceBuilder.build(), node.getSymbolMapping());
                return this.createSingleNodePlan(unionNode);
            }
            ImmutableList.Builder sourceBuilder = ImmutableList.builder();
            ImmutableList.Builder fragmentIdBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subPlan = node.getSources().get(i);
                SubPlanBuilder current = subPlan.accept(this, context);
                current.setRoot(new SinkNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), current.getRoot(), node.sourceOutputLayout(i)));
                fragmentIdBuilder.add((Object)current.getId());
                sourceBuilder.add((Object)current.build());
            }
            ExchangeNode exchangeNode = new ExchangeNode(DistributedLogicalPlanner.this.idAllocator.getNextId(), (List<PlanFragmentId>)fragmentIdBuilder.build(), node.getOutputSymbols());
            return this.createSingleNodePlan(exchangeNode).setChildren((Iterable<SubPlan>)sourceBuilder.build());
        }

        @Override
        protected SubPlanBuilder visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        public SubPlanBuilder createSingleNodePlan(PlanNode root) {
            return new SubPlanBuilder(new PlanFragmentId(this.nextSubPlanId()), this.allocator, PlanFragment.PlanDistribution.NONE, root, null);
        }

        public SubPlanBuilder createFixedDistributionPlan(PlanNode root) {
            return new SubPlanBuilder(new PlanFragmentId(this.nextSubPlanId()), this.allocator, PlanFragment.PlanDistribution.FIXED, root, null);
        }

        public SubPlanBuilder createSourceDistributionPlan(PlanNode root, PlanNodeId partitionedSourceId) {
            if (this.createSingleNodePlan) {
                return new SubPlanBuilder(new PlanFragmentId(this.nextSubPlanId()), this.allocator, PlanFragment.PlanDistribution.NONE, root, partitionedSourceId);
            }
            return new SubPlanBuilder(new PlanFragmentId(this.nextSubPlanId()), this.allocator, PlanFragment.PlanDistribution.SOURCE, root, partitionedSourceId);
        }

        public SubPlanBuilder createCoordinatorOnlyPlan(PlanNode root) {
            return new SubPlanBuilder(new PlanFragmentId(this.nextSubPlanId()), this.allocator, PlanFragment.PlanDistribution.COORDINATOR_ONLY, root, null);
        }

        private SubPlanBuilder createSubPlan(PlanNode root, PlanFragment.PlanDistribution distribution, PlanNodeId partitionedSourceId) {
            return new SubPlanBuilder(new PlanFragmentId(this.nextSubPlanId()), this.allocator, distribution, root, partitionedSourceId);
        }

        private String nextSubPlanId() {
            return String.valueOf(this.nextFragmentId++);
        }
    }
}

