/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class PageProcessorCompiler
implements BodyCompiler<PageProcessor> {
    private final Metadata metadata;

    public PageProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        this.generateProcessMethod(classDefinition, filter, projections);
        this.generateFilterMethod(classDefinition, callSiteBinder, filter);
        for (int i = 0; i < projections.size(); ++i) {
            this.generateProjectMethod(classDefinition, callSiteBinder, "project_" + i, projections.get(i));
        }
    }

    private void generateProcessMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition method = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "process", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("session", ConnectorSession.class), NamedParameterDefinition.arg("page", Page.class), NamedParameterDefinition.arg("start", Integer.TYPE), NamedParameterDefinition.arg("end", Integer.TYPE), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class));
        Variable sessionVariable = context.getVariable("session");
        Variable pageVariable = context.getVariable("page");
        Variable startVariable = context.getVariable("start");
        Variable endVariable = context.getVariable("end");
        Variable pageBuilderVariable = context.getVariable("pageBuilder");
        Variable positionVariable = context.declareVariable(Integer.TYPE, "position");
        method.getBody().comment("int position = start;").getVariable(startVariable).putVariable(positionVariable);
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        for (int channel : allInputChannels) {
            Variable blockVariable = context.declareVariable(Block.class, "block_" + channel);
            method.getBody().comment("Block %s = page.getBlock(%s);", blockVariable.getName(), channel).getVariable(pageVariable).push(channel).invokeVirtual(Page.class, "getBlock", Block.class, Integer.TYPE).putVariable(blockVariable);
        }
        LabelNode done = new LabelNode("done");
        com.facebook.presto.byteCode.Block loopBody = new com.facebook.presto.byteCode.Block(context);
        ForLoop.ForLoopBuilder loop = ForLoop.forLoopBuilder(context).initialize(OpCode.NOP).condition(new com.facebook.presto.byteCode.Block(context).comment("position < end").getVariable(positionVariable).getVariable(endVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new com.facebook.presto.byteCode.Block(context).comment("position++").incrementVariable(positionVariable, (byte)1)).body(loopBody);
        loopBody.comment("if (pageBuilder.isFull()) break;").getVariable(pageBuilderVariable).invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done);
        IfStatement.IfStatementBuilder filterBlock = new IfStatement.IfStatementBuilder(context);
        com.facebook.presto.byteCode.Block trueBlock = new com.facebook.presto.byteCode.Block(context);
        filterBlock.condition(new com.facebook.presto.byteCode.Block(context).pushThis().getVariable(sessionVariable).append(PageProcessorCompiler.pushBlockVariables(context, PageProcessorCompiler.getInputChannels(filter))).getVariable(positionVariable).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable<ParameterizedType>)ImmutableList.builder().add((Object)ParameterizedType.type(ConnectorSession.class)).addAll(Collections.nCopies(PageProcessorCompiler.getInputChannels(filter).size(), ParameterizedType.type(Block.class))).add((Object)ParameterizedType.type(Integer.TYPE)).build())).ifTrue(trueBlock);
        if (projections.size() == 0) {
            trueBlock.getVariable(pageBuilderVariable).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        } else {
            for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
                List<Integer> inputChannels = PageProcessorCompiler.getInputChannels(projections.get(projectionIndex));
                trueBlock.pushThis().getVariable(sessionVariable).append(PageProcessorCompiler.pushBlockVariables(context, inputChannels)).getVariable(positionVariable);
                trueBlock.comment("pageBuilder.getBlockBuilder(" + projectionIndex + ")").getVariable(pageBuilderVariable).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
                trueBlock.comment("project_" + projectionIndex + "(session, block_" + inputChannels + ", position, blockBuilder)").invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), (Iterable<ParameterizedType>)ImmutableList.builder().add((Object)ParameterizedType.type(ConnectorSession.class)).addAll(Collections.nCopies(inputChannels.size(), ParameterizedType.type(Block.class))).add((Object)ParameterizedType.type(Integer.TYPE)).add((Object)ParameterizedType.type(BlockBuilder.class)).build());
            }
        }
        loopBody.append(filterBlock.build());
        method.getBody().append(loop.build()).visitLabel(done).comment("return position;").getVariable(positionVariable).retInt();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition method = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable<NamedParameterDefinition>)ImmutableList.builder().add((Object)NamedParameterDefinition.arg("session", ConnectorSession.class)).addAll(PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(filter))).add((Object)NamedParameterDefinition.arg("position", Integer.TYPE)).build());
        method.comment("Filter: %s", filter.toString());
        Variable positionVariable = context.getVariable("position");
        Variable wasNullVariable = context.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(callSiteBinder, positionVariable, wasNullVariable), this.metadata.getFunctionRegistry());
        ByteCodeNode body = filter.accept(visitor, context);
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).append(body).getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition method = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)ImmutableList.builder().add((Object)NamedParameterDefinition.arg("session", ConnectorSession.class)).addAll(PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(projection))).add((Object)NamedParameterDefinition.arg("position", Integer.TYPE)).add((Object)NamedParameterDefinition.arg("output", BlockBuilder.class)).build());
        method.comment("Projection: %s", projection.toString());
        Variable positionVariable = context.getVariable("position");
        Variable outputVariable = context.getVariable("output");
        Variable wasNullVariable = context.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        com.facebook.presto.byteCode.Block body = method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false);
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(callSiteBinder, positionVariable, wasNullVariable), this.metadata.getFunctionRegistry());
        body.getVariable(outputVariable).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, context)).append(ByteCodeUtils.generateWrite(callSiteBinder, context, wasNullVariable, projection.getType())).ret();
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageProcessorCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<NamedParameterDefinition> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)NamedParameterDefinition.arg("block_" + channel, Block.class));
        }
        return parameters.build();
    }

    private static ByteCodeNode pushBlockVariables(CompilerContext context, List<Integer> inputs) {
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(context);
        for (int channel : inputs) {
            block.getVariable("block_" + channel);
        }
        return block;
    }

    private RowExpressionVisitor<CompilerContext, ByteCodeNode> fieldReferenceCompiler(final CallSiteBinder callSiteBinder, final Variable positionVariable, final Variable wasNullVariable) {
        return new RowExpressionVisitor<CompilerContext, ByteCodeNode>(){

            @Override
            public ByteCodeNode visitInputReference(InputReferenceExpression node, CompilerContext context) {
                int field = node.getField();
                Type type = node.getType();
                Class javaType = type.getJavaType();
                com.facebook.presto.byteCode.Block isNullCheck = new com.facebook.presto.byteCode.Block(context).setDescription(String.format("block_%d.get%s()", field, type)).getVariable("block_" + field).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE);
                com.facebook.presto.byteCode.Block isNull = new com.facebook.presto.byteCode.Block(context).putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                String methodName = "get" + Primitives.wrap((Class)javaType).getSimpleName();
                com.facebook.presto.byteCode.Block isNotNull = new com.facebook.presto.byteCode.Block(context).append(ByteCodeUtils.loadConstant(context, callSiteBinder.bind(type, Type.class))).getVariable("block_" + field).getVariable(positionVariable).invokeInterface(Type.class, methodName, javaType, Block.class, Integer.TYPE);
                return new IfStatement(context, isNullCheck, isNull, isNotNull);
            }

            @Override
            public ByteCodeNode visitCall(CallExpression call, CompilerContext context) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public ByteCodeNode visitConstant(ConstantExpression literal, CompilerContext context) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }
}

