/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.system.CatalogSystemTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TupleAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.UseCollection;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;

class StatementAnalyzer
extends DefaultTraversalVisitor<TupleDescriptor, AnalysisContext> {
    private final Analysis analysis;
    private final Metadata metadata;
    private final ConnectorSession session;
    private final Optional<QueryExplainer> queryExplainer;
    private final boolean experimentalSyntaxEnabled;
    private final SqlParser sqlParser;

    public StatementAnalyzer(Analysis analysis, Metadata metadata, SqlParser sqlParser, ConnectorSession session, boolean experimentalSyntaxEnabled, Optional<QueryExplainer> queryExplainer) {
        this.analysis = (Analysis)Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.session = (ConnectorSession)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
        this.queryExplainer = (Optional)Preconditions.checkNotNull(queryExplainer, (Object)"queryExplainer is null");
    }

    protected TupleDescriptor visitShowTables(ShowTables showTables, AnalysisContext context) {
        String catalogName = this.session.getCatalog();
        String schemaName = this.session.getSchema();
        QualifiedName schema = showTables.getSchema();
        if (schema != null) {
            List parts = schema.getParts();
            if (parts.size() > 2) {
                throw new SemanticException(SemanticErrorCode.INVALID_SCHEMA_NAME, (Node)showTables, "too many parts in schema name: %s", schema);
            }
            if (parts.size() == 2) {
                catalogName = (String)parts.get(0);
            }
            schemaName = schema.getSuffix();
        }
        Expression predicate = QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(schemaName));
        String likePattern = showTables.getLikePattern();
        if (likePattern != null) {
            LikePredicate likePredicate = new LikePredicate(QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(likePattern), null);
            predicate = QueryUtil.logicalAnd((Expression)predicate, (Expression)likePredicate);
        }
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"table_name", (String)"Table")}), QueryUtil.table((QualifiedName)QualifiedName.of((String)catalogName, (String[])new String[]{InformationSchemaMetadata.TABLE_TABLES.getSchemaName(), InformationSchemaMetadata.TABLE_TABLES.getTableName()})), Optional.of((Object)predicate), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.of((Object)QueryUtil.ascending((String)"table_name")), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    protected TupleDescriptor visitShowSchemas(ShowSchemas node, AnalysisContext context) {
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"schema_name", (String)"Schema")}), QueryUtil.table((QualifiedName)QualifiedName.of((String)((String)node.getCatalog().or((Object)this.session.getCatalog())), (String[])new String[]{InformationSchemaMetadata.TABLE_SCHEMATA.getSchemaName(), InformationSchemaMetadata.TABLE_SCHEMATA.getTableName()})), Optional.absent(), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.of((Object)QueryUtil.ascending((String)"schema_name")), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    protected TupleDescriptor visitShowCatalogs(ShowCatalogs node, AnalysisContext context) {
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"catalog_name", (String)"Catalog")}), QueryUtil.table((QualifiedName)QualifiedName.of((String)this.session.getCatalog(), (String[])new String[]{CatalogSystemTable.CATALOG_TABLE_NAME.getSchemaName(), CatalogSystemTable.CATALOG_TABLE_NAME.getTableName()})), Optional.absent(), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.of((Object)QueryUtil.ascending((String)"catalog_name")), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    protected TupleDescriptor visitShowColumns(ShowColumns showColumns, AnalysisContext context) {
        QualifiedTableName tableName = MetadataUtil.createQualifiedTableName(this.session, showColumns.getTable());
        if (!this.metadata.getView(this.session, tableName).isPresent() && !this.metadata.getTableHandle(this.session, tableName).isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showColumns, "Table '%s' does not exist", tableName);
        }
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"column_name", (String)"Column"), QueryUtil.aliasedName((String)"data_type", (String)"Type"), StatementAnalyzer.aliasedYesNoToBoolean("is_nullable", "Null"), StatementAnalyzer.aliasedYesNoToBoolean("is_partition_key", "Partition Key"), StatementAnalyzer.aliasedNullToEmpty("comment", "Comment")}), QueryUtil.table((QualifiedName)QualifiedName.of((String)tableName.getCatalogName(), (String[])new String[]{InformationSchemaMetadata.TABLE_COLUMNS.getSchemaName(), InformationSchemaMetadata.TABLE_COLUMNS.getTableName()})), Optional.of((Object)QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(tableName.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(tableName.getTableName())))), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.of((Object)QueryUtil.ascending((String)"ordinal_position")), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    protected TupleDescriptor visitUseCollection(UseCollection node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
    }

    private static SelectItem aliasedYesNoToBoolean(String column, String alias) {
        IfExpression expression = new IfExpression(QueryUtil.equal((Expression)QueryUtil.nameReference((String)column), (Expression)new StringLiteral("YES")), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL);
        return new SingleColumn((Expression)expression, alias);
    }

    private static SelectItem aliasedNullToEmpty(String column, String alias) {
        return new SingleColumn((Expression)new CoalesceExpression(new Expression[]{QueryUtil.nameReference((String)column), new StringLiteral("")}), alias);
    }

    protected TupleDescriptor visitShowPartitions(ShowPartitions showPartitions, AnalysisContext context) {
        QualifiedTableName table = MetadataUtil.createQualifiedTableName(this.session, showPartitions.getTable());
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, table);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showPartitions, "Table '%s' does not exist", table);
        }
        ImmutableList.Builder selectList = ImmutableList.builder();
        ImmutableList.Builder wrappedList = ImmutableList.builder();
        selectList.add((Object)QueryUtil.unaliasedName((String)"partition_number"));
        for (ColumnMetadata column : this.metadata.getTableMetadata((TableHandle)tableHandle.get()).getColumns()) {
            if (!column.isPartitionKey()) continue;
            Expression key = QueryUtil.equal((Expression)QueryUtil.nameReference((String)"partition_key"), (Expression)new StringLiteral(column.getName()));
            Expression value = QueryUtil.caseWhen((Expression)key, (Expression)QueryUtil.nameReference((String)"partition_value"));
            value = new Cast(value, column.getType().getName());
            Expression function = QueryUtil.functionCall((String)"max", (Expression[])new Expression[]{value});
            selectList.add((Object)new SingleColumn(function, column.getName()));
            wrappedList.add((Object)QueryUtil.unaliasedName((String)column.getName()));
        }
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectAll((List)selectList.build()), QueryUtil.table((QualifiedName)QualifiedName.of((String)table.getCatalogName(), (String[])new String[]{InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS.getSchemaName(), InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS.getTableName()})), Optional.of((Object)QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(table.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(table.getTableName())))), (List)ImmutableList.of((Object)QueryUtil.nameReference((String)"partition_number")), Optional.absent(), (List)ImmutableList.of(), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectAll((List)wrappedList.build()), QueryUtil.subquery((Query)query), showPartitions.getWhere(), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.builder().addAll((Iterable)showPartitions.getOrderBy()).add((Object)QueryUtil.ascending((String)"partition_number")).build(), showPartitions.getLimit()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    protected TupleDescriptor visitShowFunctions(ShowFunctions node, AnalysisContext context) {
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"function_name", (String)"Function"), QueryUtil.aliasedName((String)"return_type", (String)"Return Type"), QueryUtil.aliasedName((String)"argument_types", (String)"Argument Types"), QueryUtil.aliasedName((String)"function_type", (String)"Function Type"), QueryUtil.aliasedName((String)"description", (String)"Description")}), QueryUtil.table((QualifiedName)QualifiedName.of((String)InformationSchemaMetadata.TABLE_INTERNAL_FUNCTIONS.getSchemaName(), (String[])new String[]{InformationSchemaMetadata.TABLE_INTERNAL_FUNCTIONS.getTableName()})), Optional.absent(), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.of((Object)QueryUtil.ascending((String)"function_name"), (Object)QueryUtil.ascending((String)"return_type"), (Object)QueryUtil.ascending((String)"argument_types"), (Object)QueryUtil.ascending((String)"function_type")), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    protected TupleDescriptor visitInsert(Insert insert, AnalysisContext context) {
        TupleDescriptor descriptor = (TupleDescriptor)this.process((Node)insert.getQuery(), context);
        QualifiedTableName targetTable = MetadataUtil.createQualifiedTableName(this.session, insert.getTarget());
        Optional<TableHandle> targetTableHandle = this.metadata.getTableHandle(this.session, targetTable);
        if (!targetTableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)insert, "Table '%s' does not exist", targetTable);
        }
        this.analysis.setInsertTarget((TableHandle)targetTableHandle.get());
        List<ColumnMetadata> columns = this.metadata.getTableMetadata((TableHandle)targetTableHandle.get()).getColumns();
        Iterable tableTypes = Iterables.transform(columns, MetadataUtil.columnTypeGetter());
        Iterable queryTypes = Iterables.transform(descriptor.getVisibleFields(), Field.typeGetter());
        if (!Iterables.elementsEqual((Iterable)tableTypes, (Iterable)queryTypes)) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)insert, "Insert query has mismatched column types: Table: (" + Joiner.on((String)", ").join(tableTypes) + "), " + "Query: (" + Joiner.on((String)", ").join(queryTypes) + ")", new Object[0]);
        }
        return new TupleDescriptor(Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    protected TupleDescriptor visitCreateTable(CreateTable node, AnalysisContext context) {
        QualifiedTableName targetTable = MetadataUtil.createQualifiedTableName(this.session, node.getName());
        this.analysis.setCreateTableDestination(targetTable);
        Optional<TableHandle> targetTableHandle = this.metadata.getTableHandle(this.session, targetTable);
        if (targetTableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", targetTable);
        }
        TupleDescriptor descriptor = (TupleDescriptor)this.process((Node)node.getQuery(), context);
        StatementAnalyzer.validateColumnNames((Statement)node, descriptor);
        return new TupleDescriptor(Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    protected TupleDescriptor visitCreateView(CreateView node, AnalysisContext context) {
        TupleDescriptor descriptor = (TupleDescriptor)this.process((Node)node.getQuery(), context);
        StatementAnalyzer.validateColumnNames((Statement)node, descriptor);
        return descriptor;
    }

    private static void validateColumnNames(Statement node, TupleDescriptor descriptor) {
        HashSet<Object> names = new HashSet<Object>();
        for (Field field : descriptor.getVisibleFields()) {
            Optional<String> fieldName = field.getName();
            if (!fieldName.isPresent()) {
                throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)node, "Column name not specified at position %s", descriptor.indexOf(field) + 1);
            }
            if (names.add(fieldName.get())) continue;
            throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", fieldName.get());
        }
    }

    protected TupleDescriptor visitExplain(Explain node, AnalysisContext context) throws SemanticException {
        Preconditions.checkState((boolean)this.queryExplainer.isPresent(), (Object)"query explainer not available");
        ExplainType.Type planType = ExplainType.Type.LOGICAL;
        ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
        List options = node.getOptions();
        for (ExplainOption option : options) {
            if (!(option instanceof ExplainType)) continue;
            planType = ((ExplainType)option).getType();
            break;
        }
        for (ExplainOption option : options) {
            if (!(option instanceof ExplainFormat)) continue;
            planFormat = ((ExplainFormat)option).getType();
            break;
        }
        String queryPlan = this.getQueryPlan(node, planType, planFormat);
        Query query = new Query(Optional.absent(), (QueryBody)new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (List)ImmutableList.of((Object)QueryUtil.aliased((Relation)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new StringLiteral(queryPlan)})}), (String)"plan", (List)ImmutableList.of((Object)"Query Plan"))), Optional.absent(), (List)ImmutableList.of(), Optional.absent(), (List)ImmutableList.of(), Optional.absent()), (List)ImmutableList.of(), Optional.absent(), Optional.absent());
        return (TupleDescriptor)this.process((Node)query, context);
    }

    private String getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
        switch (planFormat) {
            case GRAPHVIZ: {
                return ((QueryExplainer)this.queryExplainer.get()).getGraphvizPlan(node.getStatement(), planType);
            }
            case TEXT: {
                return ((QueryExplainer)this.queryExplainer.get()).getPlan(node.getStatement(), planType);
            }
            case JSON: {
                return ((QueryExplainer)this.queryExplainer.get()).getJsonPlan(node.getStatement());
            }
        }
        throw new IllegalArgumentException("Invalid Explain Format: " + planFormat.toString());
    }

    protected TupleDescriptor visitQuery(Query node, AnalysisContext parentContext) {
        AnalysisContext context = new AnalysisContext(parentContext);
        if (node.getApproximate().isPresent()) {
            if (!this.experimentalSyntaxEnabled) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "approximate queries are not enabled", new Object[0]);
            }
            context.setApproximate(true);
        }
        this.analyzeWith(node, context);
        TupleAnalyzer analyzer = new TupleAnalyzer(this.analysis, this.session, this.metadata, this.sqlParser, this.experimentalSyntaxEnabled);
        TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)node.getQueryBody(), context);
        this.analyzeOrderBy(node, descriptor, context);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        this.analysis.setOutputExpressions((Node)node, this.descriptorToFields(descriptor));
        this.analysis.setQuery(node);
        return descriptor;
    }

    private List<FieldOrExpression> descriptorToFields(TupleDescriptor tupleDescriptor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int fieldIndex = 0; fieldIndex < tupleDescriptor.getAllFieldCount(); ++fieldIndex) {
            builder.add((Object)new FieldOrExpression(fieldIndex));
        }
        return builder.build();
    }

    private void analyzeWith(Query node, AnalysisContext context) {
        if (!node.getWith().isPresent()) {
            return;
        }
        With with = (With)node.getWith().get();
        if (with.isRecursive()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)with, "Recursive WITH queries are not supported", new Object[0]);
        }
        for (WithQuery withQuery : with.getQueries()) {
            if (withQuery.getColumnNames() != null && !withQuery.getColumnNames().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)withQuery, "Column alias not supported in WITH queries", new Object[0]);
            }
            Query query = withQuery.getQuery();
            this.process((Node)query, context);
            String name = withQuery.getName();
            if (context.isNamedQueryDeclared(name)) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)withQuery, "WITH query name '%s' specified more than once", name);
            }
            context.addNamedQuery(name, query);
        }
    }

    private void analyzeOrderBy(Query node, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            for (SortItem item : items) {
                FieldOrExpression orderByField;
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)tupleDescriptor.getVisibleFieldCount()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    orderByField = new FieldOrExpression((int)(ordinal - 1L));
                } else {
                    orderByField = new FieldOrExpression(expression);
                    ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.sqlParser, tupleDescriptor, this.analysis, this.experimentalSyntaxEnabled, context, orderByField.getExpression());
                    this.analysis.addInPredicates(node, expressionAnalysis.getSubqueryInPredicates());
                }
                orderByFieldsBuilder.add((Object)orderByField);
            }
        }
        this.analysis.setOrderByExpressions((Node)node, (List<FieldOrExpression>)orderByFieldsBuilder.build());
    }
}

