/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ExpressionAnalyzer {
    private final Analysis analysis;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final boolean experimentalSyntaxEnabled;
    private final ConnectorSession session;
    private final Map<QualifiedName, Integer> resolvedNames = new HashMap<QualifiedName, Integer>();
    private final IdentityHashMap<FunctionCall, FunctionInfo> resolvedFunctions = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> expressionTypes = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> expressionCoercions = new IdentityHashMap();
    private final Set<InPredicate> subqueryInPredicates = Collections.newSetFromMap(new IdentityHashMap());

    public ExpressionAnalyzer(Analysis analysis, ConnectorSession session, Metadata metadata, SqlParser sqlParser, boolean experimentalSyntaxEnabled) {
        this.analysis = (Analysis)Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        this.session = (ConnectorSession)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
    }

    public Map<QualifiedName, Integer> getResolvedNames() {
        return this.resolvedNames;
    }

    public IdentityHashMap<FunctionCall, FunctionInfo> getResolvedFunctions() {
        return this.resolvedFunctions;
    }

    public IdentityHashMap<Expression, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public IdentityHashMap<Expression, Type> getExpressionCoercions() {
        return this.expressionCoercions;
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Type analyze(Expression expression, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        Visitor visitor = new Visitor(tupleDescriptor);
        return (Type)expression.accept((AstVisitor)visitor, (Object)context);
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypes(ConnectorSession session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Expression expression) {
        return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, types, (Iterable<? extends Expression>)ImmutableList.of((Object)expression));
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypes(ConnectorSession session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Iterable<? extends Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressionsWithSymbols(session, metadata, sqlParser, types, expressions).getExpressionTypes();
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypesFromInput(ConnectorSession session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Expression expression) {
        return ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, types, (Iterable<? extends Expression>)ImmutableList.of((Object)expression));
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypesFromInput(ConnectorSession session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Iterable<? extends Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressionsWithInputs(session, metadata, sqlParser, types, expressions).getExpressionTypes();
    }

    public static ExpressionAnalysis analyzeExpressionsWithSymbols(ConnectorSession session, Metadata metadata, SqlParser sqlParser, final Map<Symbol, Type> types, Iterable<? extends Expression> expressions) {
        List<Field> fields = IterableTransformer.on(DependencyExtractor.extractUnique(expressions)).transform(new Function<Symbol, Field>(){

            public Field apply(Symbol symbol) {
                Type type = (Type)types.get(symbol);
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No type for symbol %s", (Object[])new Object[]{symbol});
                return Field.newUnqualified(symbol.getName(), type);
            }
        }).list();
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, new TupleDescriptor(fields), expressions);
    }

    public static ExpressionAnalysis analyzeExpressionsWithInputs(ConnectorSession session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Iterable<? extends Expression> expressions) {
        Field[] fields = new Field[types.size()];
        for (Map.Entry<Integer, Type> entry : types.entrySet()) {
            fields[entry.getKey().intValue()] = Field.newUnqualified((Optional<String>)Optional.absent(), entry.getValue());
        }
        TupleDescriptor tupleDescriptor = new TupleDescriptor(fields);
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, tupleDescriptor, expressions);
    }

    private static ExpressionAnalysis analyzeExpressions(ConnectorSession session, Metadata metadata, SqlParser sqlParser, TupleDescriptor tupleDescriptor, Iterable<? extends Expression> expressions) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(new Analysis(), session, metadata, sqlParser, false);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, tupleDescriptor, new AnalysisContext());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates());
    }

    public static ExpressionAnalysis analyzeExpression(ConnectorSession session, Metadata metadata, SqlParser sqlParser, TupleDescriptor tupleDescriptor, Analysis analysis, boolean approximateQueriesEnabled, AnalysisContext context, Expression expression) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(analysis, session, metadata, sqlParser, approximateQueriesEnabled);
        analyzer.analyze(expression, tupleDescriptor, context);
        IdentityHashMap<Expression, Type> expressionTypes = analyzer.getExpressionTypes();
        IdentityHashMap<Expression, Type> expressionCoercions = analyzer.getExpressionCoercions();
        IdentityHashMap<FunctionCall, FunctionInfo> resolvedFunctions = analyzer.getResolvedFunctions();
        analysis.addTypes(expressionTypes);
        analysis.addCoercions(expressionCoercions);
        analysis.addFunctionInfos(resolvedFunctions);
        for (Expression subExpression : expressionTypes.keySet()) {
            analysis.addResolvedNames(subExpression, analyzer.getResolvedNames());
        }
        Set<InPredicate> subqueryInPredicates = analyzer.getSubqueryInPredicates();
        return new ExpressionAnalysis(expressionTypes, expressionCoercions, subqueryInPredicates);
    }

    private class Visitor
    extends AstVisitor<Type, AnalysisContext> {
        private final TupleDescriptor tupleDescriptor;

        private Visitor(TupleDescriptor tupleDescriptor) {
            this.tupleDescriptor = (TupleDescriptor)Preconditions.checkNotNull((Object)tupleDescriptor, (Object)"tupleDescriptor is null");
        }

        public Type process(Node node, @Nullable AnalysisContext context) {
            Type type = (Type)ExpressionAnalyzer.this.expressionTypes.get(node);
            if (type != null) {
                return type;
            }
            return (Type)super.process(node, (Object)context);
        }

        protected Type visitCurrentTime(CurrentTime node, AnalysisContext context) {
            DateType type;
            if (node.getPrecision() != null) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "non-default precision not yet supported", new Object[0]);
            }
            switch (node.getType()) {
                case DATE: {
                    type = DateType.DATE;
                    break;
                }
                case TIME: {
                    type = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIME: {
                    type = TimeType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    type = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIMESTAMP: {
                    type = TimestampType.TIMESTAMP;
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "%s not yet supported", node.getType().getName());
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitQualifiedNameReference(QualifiedNameReference node, AnalysisContext context) {
            List<Field> matches = this.tupleDescriptor.resolveFields(node.getName());
            if (matches.isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", node.getName());
            }
            if (matches.size() > 1) {
                throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)node, "Column '%s' is ambiguous", node.getName());
            }
            Field field = (Field)Iterables.getOnlyElement(matches);
            int fieldIndex = this.tupleDescriptor.indexOf(field);
            ExpressionAnalyzer.this.resolvedNames.put(node.getName(), fieldIndex);
            ExpressionAnalyzer.this.expressionTypes.put(node, field.getType());
            return field.getType();
        }

        protected Type visitNotExpression(NotExpression node, AnalysisContext context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitLogicalBinaryExpression(LogicalBinaryExpression node, AnalysisContext context) {
            this.coerceType(context, node.getLeft(), (Type)BooleanType.BOOLEAN, "Left side of logical expression");
            this.coerceType(context, node.getRight(), (Type)BooleanType.BOOLEAN, "Right side of logical expression");
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitComparisonExpression(ComparisonExpression node, AnalysisContext context) {
            OperatorType operatorType = node.getType() == ComparisonExpression.Type.IS_DISTINCT_FROM ? OperatorType.EQUAL : OperatorType.valueOf(node.getType().name());
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, AnalysisContext context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, AnalysisContext context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitNullIfExpression(NullIfExpression node, AnalysisContext context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (!FunctionRegistry.getCommonSuperType(firstType, secondType = this.process((Node)node.getSecond(), context)).isPresent()) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, firstType);
            return firstType;
        }

        protected Type visitIfExpression(IfExpression node, AnalysisContext context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same: %s vs %s", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, AnalysisContext context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                Preconditions.checkNotNull((Object)whenClauseType, (String)"Expression types does not contain an entry for %s", (Object[])new Object[]{whenClause});
                ExpressionAnalyzer.this.expressionTypes.put(whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, AnalysisContext context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceToSingleType(context, (Node)node, "CASE operand type does not match WHEN clause operand type: %s vs %s", node.getOperand(), whenClause.getOperand());
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                Preconditions.checkNotNull((Object)whenClauseType, (String)"Expression types does not contain an entry for %s", (Object[])new Object[]{whenClause});
                ExpressionAnalyzer.this.expressionTypes.put(whenClause, whenClauseType);
            }
            return type;
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Expression defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            if (defaultValue != null) {
                resultExpressions.add(defaultValue);
            }
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, AnalysisContext context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands must be the same type: %s", node.getOperands());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitNegativeExpression(NegativeExpression node, AnalysisContext context) {
            return this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
        }

        protected Type visitArithmeticExpression(ArithmeticExpression node, AnalysisContext context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf(node.getType().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, AnalysisContext context) {
            this.coerceType(context, node.getValue(), (Type)VarcharType.VARCHAR, "Left side of LIKE expression");
            this.coerceType(context, node.getPattern(), (Type)VarcharType.VARCHAR, "Pattern for LIKE expression");
            if (node.getEscape() != null) {
                this.coerceType(context, node.getEscape(), (Type)VarcharType.VARCHAR, "Escape for LIKE expression");
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitStringLiteral(StringLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, VarcharType.VARCHAR);
            return VarcharType.VARCHAR;
        }

        protected Type visitLongLiteral(LongLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, BigintType.BIGINT);
            return BigintType.BIGINT;
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, DoubleType.DOUBLE);
            return DoubleType.DOUBLE;
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitGenericLiteral(GenericLiteral node, AnalysisContext context) {
            Type type = ExpressionAnalyzer.this.metadata.getType(node.getType());
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            try {
                ExpressionAnalyzer.this.metadata.getFunctionRegistry().getCoercion((Type)VarcharType.VARCHAR, type);
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitTimeLiteral(TimeLiteral node, AnalysisContext context) {
            Object type = DateTimeUtils.timeHasTimeZone(node.getValue()) ? TimeWithTimeZoneType.TIME_WITH_TIME_ZONE : TimeType.TIME;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, AnalysisContext context) {
            Object type = DateTimeUtils.timestampHasTimeZone(node.getValue()) ? TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE : TimestampType.TIMESTAMP;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, AnalysisContext context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitNullLiteral(NullLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, UnknownType.UNKNOWN);
            return UnknownType.UNKNOWN;
        }

        protected Type visitFunctionCall(FunctionCall node, AnalysisContext context) {
            if (node.getWindow().isPresent()) {
                for (Expression expression : ((Window)node.getWindow().get()).getPartitionBy()) {
                    this.process((Node)expression, context);
                }
                for (SortItem sortItem : ((Window)node.getWindow().get()).getOrderBy()) {
                    this.process((Node)sortItem.getSortKey(), context);
                }
            }
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : node.getArguments()) {
                argumentTypes.add((Object)this.process((Node)expression, context).getName());
            }
            FunctionInfo function = ExpressionAnalyzer.this.metadata.resolveFunction(node.getName(), (List<String>)argumentTypes.build(), context.isApproximate());
            for (int i = 0; i < node.getArguments().size(); ++i) {
                Expression expression = (Expression)node.getArguments().get(i);
                Type type = ExpressionAnalyzer.this.metadata.getType(function.getArgumentTypes().get(i));
                Preconditions.checkNotNull((Object)type, (String)"Type %s not found", (Object[])new Object[]{function.getArgumentTypes().get(i)});
                this.coerceType(context, expression, type, String.format("Function %s argument %d", function.getSignature(), i));
            }
            ExpressionAnalyzer.this.resolvedFunctions.put(node, function);
            Type type = ExpressionAnalyzer.this.metadata.getType(function.getReturnType());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitExtract(Extract node, AnalysisContext context) {
            Type type = this.process((Node)node.getExpression(), context);
            if (!this.isDateTimeType(type)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract must be DATE, TIME, TIMESTAMP, or INTERVAL (actual %s)", type);
            }
            Extract.Field field = node.getField();
            if ((field == Extract.Field.TIMEZONE_HOUR || field == Extract.Field.TIMEZONE_MINUTE) && type != TimeWithTimeZoneType.TIME_WITH_TIME_ZONE && type != TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract time zone field must have a time zone (actual %s)", type);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BigintType.BIGINT);
            return BigintType.BIGINT;
        }

        private boolean isDateTimeType(Type type) {
            return type == DateType.DATE || type == TimeType.TIME || type == TimeWithTimeZoneType.TIME_WITH_TIME_ZONE || type == TimestampType.TIMESTAMP || type == TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE || type == IntervalDayTimeType.INTERVAL_DAY_TIME || type == IntervalYearMonthType.INTERVAL_YEAR_MONTH;
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, AnalysisContext context) {
            return this.getOperator(context, (Expression)node, OperatorType.BETWEEN, node.getValue(), node.getMin(), node.getMax());
        }

        public Type visitCast(Cast node, AnalysisContext context) {
            Type type = ExpressionAnalyzer.this.metadata.getType(node.getType());
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (value != UnknownType.UNKNOWN) {
                try {
                    ExpressionAnalyzer.this.metadata.getFunctionRegistry().getCoercion(value, type);
                }
                catch (OperatorNotFoundException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitInPredicate(InPredicate node, AnalysisContext context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression valueList = node.getValueList();
            this.process((Node)valueList, context);
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                this.coerceToSingleType(context, "IN value and list items must be the same type: %s", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
            } else if (valueList instanceof SubqueryExpression) {
                ExpressionAnalyzer.this.subqueryInPredicates.add(node);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitInListExpression(InListExpression node, AnalysisContext context) {
            Type type = this.coerceToSingleType(context, "All IN list values must be the same type: %s", node.getValues());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, AnalysisContext context) {
            StatementAnalyzer analyzer = new StatementAnalyzer(ExpressionAnalyzer.this.analysis, ExpressionAnalyzer.this.metadata, ExpressionAnalyzer.this.sqlParser, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.experimentalSyntaxEnabled, (Optional<QueryExplainer>)Optional.absent());
            TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)node.getQuery(), context);
            if (descriptor.getVisibleFieldCount() != 1) {
                throw new SemanticException(SemanticErrorCode.MULTIPLE_FIELDS_FROM_SCALAR_SUBQUERY, (Node)node, "Subquery expression must produce only one field. Found %s", descriptor.getVisibleFieldCount());
            }
            Type type = ((Field)Iterables.getOnlyElement(descriptor.getVisibleFields())).getType();
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        public Type visitInputReference(InputReference node, AnalysisContext context) {
            Type type = this.tupleDescriptor.getFieldByIndex(node.getChannel()).getType();
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitExpression(Expression node, AnalysisContext context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Type getOperator(AnalysisContext context, Expression node, OperatorType operatorType, Expression ... arguments) {
            FunctionInfo operatorInfo;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorInfo = ExpressionAnalyzer.this.metadata.resolveOperator(operatorType, (List<? extends Type>)argumentTypes.build());
            }
            catch (OperatorNotFoundException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, e.getMessage(), new Object[0]);
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = ExpressionAnalyzer.this.metadata.getType(operatorInfo.getArgumentTypes().get(i));
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorInfo, i));
            }
            Type type = ExpressionAnalyzer.this.metadata.getType(operatorInfo.getReturnType());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        private void coerceType(AnalysisContext context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            if (!actualType.equals(expectedType)) {
                if (!FunctionRegistry.canCoerce(actualType, expectedType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message + " must evaluate to a %s (actual: %s)", expectedType, actualType);
                }
                ExpressionAnalyzer.this.expressionCoercions.put(expression, expectedType);
            }
        }

        private Type coerceToSingleType(AnalysisContext context, Node node, String message, Expression first, Expression second) {
            Type firstType = null;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            Type secondType = null;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if (firstType == null) {
                return secondType;
            }
            if (secondType == null) {
                return firstType;
            }
            if (firstType.equals(secondType)) {
                return firstType;
            }
            if (FunctionRegistry.canCoerce(firstType, secondType)) {
                ExpressionAnalyzer.this.expressionCoercions.put(first, secondType);
                return secondType;
            }
            if (FunctionRegistry.canCoerce(secondType, firstType)) {
                ExpressionAnalyzer.this.expressionCoercions.put(second, firstType);
                return firstType;
            }
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, message, firstType, secondType);
        }

        private Type coerceToSingleType(AnalysisContext context, String message, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            for (Expression expression : expressions) {
                Optional<Type> newSuperType = FunctionRegistry.getCommonSuperType((Type)superType, this.process((Node)expression, context));
                if (!newSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                superType = (Type)newSuperType.get();
            }
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                if (type.equals((Object)superType)) continue;
                if (!FunctionRegistry.canCoerce(type, (Type)superType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                ExpressionAnalyzer.this.expressionCoercions.put(expression, superType);
            }
            return superType;
        }
    }
}

