/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Set;

public class ExpressionAnalysis {
    private final IdentityHashMap<Expression, Type> expressionTypes;
    private final IdentityHashMap<Expression, Type> expressionCoercions;
    private final Set<InPredicate> subqueryInPredicates;

    public ExpressionAnalysis(IdentityHashMap<Expression, Type> expressionTypes, IdentityHashMap<Expression, Type> expressionCoercions, Set<InPredicate> subqueryInPredicates) {
        this.expressionTypes = (IdentityHashMap)Preconditions.checkNotNull(expressionTypes, (Object)"expressionTypes is null");
        this.expressionCoercions = (IdentityHashMap)Preconditions.checkNotNull(expressionCoercions, (Object)"expressionCoercions is null");
        this.subqueryInPredicates = (Set)Preconditions.checkNotNull(subqueryInPredicates, (Object)"subqueryInPredicates is null");
    }

    public Type getType(Expression expression) {
        return this.expressionTypes.get(expression);
    }

    public IdentityHashMap<Expression, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public Type getCoercion(Expression expression) {
        return this.expressionCoercions.get(expression);
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }
}

