/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static Optional<Map<ConnectorColumnHandle, Object>> extractConstantValues(Expression predicate, Map<Symbol, ConnectorColumnHandle> symbolToColumnName) {
        Set<ComparisonExpression> comparisons = IterableTransformer.on(ExpressionUtils.extractConjuncts(predicate)).select((Predicate<Expression>)Predicates.instanceOf(ComparisonExpression.class)).cast(ComparisonExpression.class).select((Predicate<ComparisonExpression>)Predicates.or((Predicate[])new Predicate[]{ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, QualifiedNameReference.class, StringLiteral.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, StringLiteral.class, QualifiedNameReference.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, QualifiedNameReference.class, LongLiteral.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, LongLiteral.class, QualifiedNameReference.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, QualifiedNameReference.class, DoubleLiteral.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, DoubleLiteral.class, QualifiedNameReference.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, QualifiedNameReference.class, BooleanLiteral.class), ComparisonExpression.matchesPattern((ComparisonExpression.Type)ComparisonExpression.Type.EQUAL, BooleanLiteral.class, QualifiedNameReference.class)})).set();
        HashMap<ConnectorColumnHandle, Object> bindings = new HashMap<ConnectorColumnHandle, Object>();
        for (ComparisonExpression comparison : comparisons) {
            Object value;
            QualifiedNameReference reference = ExpressionUtil.extractReference(comparison);
            Symbol symbol = Symbol.fromQualifiedName(reference.getName());
            ConnectorColumnHandle column = symbolToColumnName.get(symbol);
            if (column == null) continue;
            Literal literal = ExpressionUtil.extractLiteral(comparison);
            if (literal instanceof DoubleLiteral) {
                value = ((DoubleLiteral)literal).getValue();
            } else if (literal instanceof LongLiteral) {
                value = ((LongLiteral)literal).getValue();
            } else if (literal instanceof StringLiteral) {
                value = ((StringLiteral)literal).getValue();
            } else if (literal instanceof BooleanLiteral) {
                value = ((BooleanLiteral)literal).getValue();
            } else {
                throw new AssertionError((Object)String.format("Literal type (%s) not currently handled", literal.getClass().getName()));
            }
            Object previous = bindings.get(column);
            if (previous != null && !previous.equals(value)) {
                return Optional.absent();
            }
            bindings.put(column, value);
        }
        return Optional.of(bindings);
    }

    private static Literal extractLiteral(ComparisonExpression expression) {
        if (expression.getLeft() instanceof Literal) {
            return (Literal)expression.getLeft();
        }
        if (expression.getRight() instanceof Literal) {
            return (Literal)expression.getRight();
        }
        throw new IllegalArgumentException("Comparison does not have a child of type Literal");
    }

    private static QualifiedNameReference extractReference(ComparisonExpression expression) {
        if (expression.getLeft() instanceof QualifiedNameReference) {
            return (QualifiedNameReference)expression.getLeft();
        }
        if (expression.getRight() instanceof QualifiedNameReference) {
            return (QualifiedNameReference)expression.getRight();
        }
        throw new IllegalArgumentException("Comparison does not have a child of type QualifiedNameReference");
    }
}

