/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.DataStreamProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class DataStreamManager
implements DataStreamProvider {
    private final ConcurrentMap<String, ConnectorDataStreamProvider> dataStreamProviders = new ConcurrentHashMap<String, ConnectorDataStreamProvider>();

    @Inject
    public DataStreamManager() {
    }

    public void addConnectorDataStreamProvider(String connectorId, ConnectorDataStreamProvider connectorDataStreamProvider) {
        this.dataStreamProviders.put(connectorId, connectorDataStreamProvider);
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        List handles = Lists.transform(columns, ColumnHandle.connectorHandleGetter());
        return this.getDataStreamProvider(split).createNewDataStream(operatorContext, split.getConnectorSplit(), handles);
    }

    private ConnectorDataStreamProvider getDataStreamProvider(Split split) {
        ConnectorDataStreamProvider provider = (ConnectorDataStreamProvider)this.dataStreamProviders.get(split.getConnectorId());
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No data stream provider for '%s", (Object[])new Object[]{split.getConnectorId()});
        return provider;
    }
}

