/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.testing;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

final class FileUtils {
    private FileUtils() {
    }

    public static void deleteRecursively(Path path) {
        try {
            Files.walkFileTree(path, FileUtils.deletionVisitor());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static FileVisitor<Path> deletionVisitor() {
        return new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileUtils.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                FileUtils.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                FileUtils.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private static void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

