/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import io.airlift.log.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.concurrent.atomic.AtomicBoolean;

final class CodeCacheGcTrigger {
    private static final AtomicBoolean installed = new AtomicBoolean();

    private CodeCacheGcTrigger() {
    }

    public static void installCodeCacheGcTrigger() {
        if (installed.getAndSet(true)) {
            return;
        }
        final MemoryPoolMXBean codeCacheMbean = CodeCacheGcTrigger.findCodeCacheMBean();
        Thread gcThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Logger log = Logger.get((String)"Code-Cache-GC-Trigger");
                while (!Thread.currentThread().isInterrupted()) {
                    long max;
                    long used = codeCacheMbean.getUsage().getUsed();
                    if ((double)used > 0.95 * (double)(max = codeCacheMbean.getUsage().getMax())) {
                        log.error("Code Cache is more than 95% full. JIT may stop working.");
                    }
                    if ((double)used > 0.7 * (double)max) {
                        log.info("Triggering GC to avoid Code Cache eviction bugs");
                        System.gc();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        gcThread.setDaemon(true);
        gcThread.setName("Code-Cache-GC-Trigger");
        gcThread.start();
    }

    private static MemoryPoolMXBean findCodeCacheMBean() {
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!bean.getName().equals("Code Cache")) continue;
            return bean;
        }
        throw new RuntimeException("Could not obtain a reference to the 'Code Cache' MemoryPoolMXBean");
    }
}

