/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;

public final class AsyncResponseUtils {
    private AsyncResponseUtils() {
    }

    public static void registerAsyncResponse(AsyncResponse asyncResponse, ListenableFuture<?> futureResponse, Duration timeout, Executor executor) {
        Response timeoutResponse = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)("Timed out after waiting for " + timeout.convertToMostSuccinctTimeUnit())).build();
        AsyncResponseUtils.registerAsyncResponse(asyncResponse, futureResponse, timeout, executor, timeoutResponse);
    }

    public static void registerAsyncResponse(AsyncResponse asyncResponse, ListenableFuture<?> futureResponse, Duration requestTimeout, Executor executor, Response timeoutResponse) {
        Futures.addCallback(futureResponse, AsyncResponseUtils.toAsyncResponse(asyncResponse), (Executor)executor);
        asyncResponse.setTimeoutHandler((TimeoutHandler)new AsyncTimeoutHandler(futureResponse, timeoutResponse));
        asyncResponse.setTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static <T> FutureCallback<T> toAsyncResponse(final AsyncResponse asyncResponse) {
        return new FutureCallback<T>(){

            public void onSuccess(T value) {
                Preconditions.checkArgument((!(value instanceof Response.ResponseBuilder) ? 1 : 0) != 0, (Object)"Value is a ResponseBuilder. Did you forget to call build?");
                asyncResponse.resume(value);
            }

            public void onFailure(Throwable t) {
                asyncResponse.resume(t);
            }
        };
    }

    private static class AsyncTimeoutHandler
    implements TimeoutHandler {
        private final WeakReference<ListenableFuture<?>> futureResponseReference;
        private final Response timeoutResponse;

        public AsyncTimeoutHandler(ListenableFuture<?> futureResponse, Response timeoutResponse) {
            this.futureResponseReference = new WeakReference(futureResponse);
            this.timeoutResponse = timeoutResponse;
        }

        public void handleTimeout(AsyncResponse asyncResponse) {
            asyncResponse.resume((Object)this.timeoutResponse);
            ListenableFuture futureResponse = (ListenableFuture)this.futureResponseReference.get();
            if (futureResponse != null) {
                try {
                    futureResponse.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

