/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.DictionaryEncoder;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.serde.RunLengthEncoder;
import com.facebook.presto.serde.SnappyEncoder;
import com.facebook.presto.serde.UncompressedEncoder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public enum BlocksFileEncoding {
    RAW("raw"){

        @Override
        public Encoder createBlocksWriter(Type type, SliceOutput sliceOutput) {
            return new UncompressedEncoder(type, sliceOutput);
        }
    }
    ,
    RLE("rle"){

        @Override
        public Encoder createBlocksWriter(Type type, SliceOutput sliceOutput) {
            return new RunLengthEncoder(sliceOutput, type);
        }
    }
    ,
    DIC_RAW("dic-raw"){

        @Override
        public Encoder createBlocksWriter(Type type, SliceOutput sliceOutput) {
            return new DictionaryEncoder(type, new UncompressedEncoder(type, sliceOutput));
        }
    }
    ,
    DIC_RLE("dic-rle"){

        @Override
        public Encoder createBlocksWriter(Type type, SliceOutput sliceOutput) {
            return new DictionaryEncoder(type, new RunLengthEncoder(sliceOutput, type));
        }
    }
    ,
    SNAPPY("snappy"){

        @Override
        public Encoder createBlocksWriter(Type type, SliceOutput sliceOutput) {
            return new SnappyEncoder(type, sliceOutput);
        }
    };

    private final String name;

    private BlocksFileEncoding(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
    }

    public String getName() {
        return this.name;
    }

    public abstract Encoder createBlocksWriter(Type var1, SliceOutput var2);
}

