/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.operator.scalar.JsonPath;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.type.SqlType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Charsets;
import com.google.common.primitives.Doubles;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import javax.annotation.Nullable;

public final class JsonFunctions {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonFunctions() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="JsonPath")
    public static JsonPath castToJsonPath(@SqlType(value="varchar") Slice pattern) {
        return new JsonPath(pattern.toString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="bigint")
    public static Long jsonArrayLength(@SqlType(value="varchar") Slice json) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Long l = null;
                return l;
            }
            long length = 0L;
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Long l = null;
                    return l;
                }
                if (token == JsonToken.END_ARRAY) {
                    Long l = length;
                    return l;
                }
                parser.skipChildren();
                ++length;
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="boolean") boolean value) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_TRUE && value || token == JsonToken.VALUE_FALSE && !value) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="bigint") long value) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_NUMBER_INT && (parser.getNumberType() == JsonParser.NumberType.INT || parser.getNumberType() == JsonParser.NumberType.LONG) && parser.getLongValue() == value) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="double") double value) {
        if (!Doubles.isFinite((double)value)) {
            return false;
        }
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_NUMBER_FLOAT && parser.getDoubleValue() == value && Doubles.isFinite((double)parser.getDoubleValue())) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="varchar") Slice value) {
        String valueString = value.toString(Charsets.UTF_8);
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_STRING && valueString.equals(parser.getValueAsString())) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice jsonArrayGet(@SqlType(value="varchar") Slice json, @SqlType(value="bigint") long index) {
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Slice slice = null;
                return slice;
            }
            LinkedList<String> tokens = null;
            if (index < 0L) {
                tokens = new LinkedList<String>();
            }
            long count = 0L;
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Slice slice = null;
                    return slice;
                }
                if (token == JsonToken.END_ARRAY) {
                    if (tokens != null && count >= index * -1L) {
                        Slice slice = Slices.utf8Slice((String)((String)tokens.get(0)));
                        return slice;
                    }
                    Slice slice = null;
                    return slice;
                }
                parser.skipChildren();
                if (count == index) {
                    if (parser.getValueAsString() == null) {
                        Slice slice = null;
                        return slice;
                    }
                    Slice slice = Slices.utf8Slice((String)parser.getValueAsString());
                    return slice;
                }
                if (tokens != null) {
                    tokens.add(parser.getValueAsString());
                    if (count >= index * -1L) {
                        tokens.remove(0);
                    }
                }
                ++count;
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @ScalarFunction
    @Nullable
    @SqlType(value="varchar")
    public static Slice jsonExtractScalar(@SqlType(value="varchar") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getScalarExtractor());
    }

    @ScalarFunction
    @Nullable
    @SqlType(value="varchar")
    public static Slice jsonExtract(@SqlType(value="varchar") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getObjectExtractor());
    }

    @ScalarFunction
    @Nullable
    @SqlType(value="bigint")
    public static Long jsonSize(@SqlType(value="varchar") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getSizeExtractor());
    }
}

