/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class IdentityCastParametricFunction
extends ParametricOperator {
    public static final IdentityCastParametricFunction IDENTITY_CAST = new IdentityCastParametricFunction();

    protected IdentityCastParametricFunction() {
        super(OperatorType.CAST, (List<Signature.TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "T", (List<String>)ImmutableList.of((Object)"T"));
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public FunctionInfo specialize(List<? extends Type> types) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Expected only one type");
        Type type = types.get(0);
        MethodHandle identity = MethodHandles.identity(type.getJavaType());
        return FunctionRegistry.operatorInfo(OperatorType.CAST, type.getName(), (List<String>)ImmutableList.of((Object)type.getName()), identity, false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    @Override
    public FunctionInfo specialize(Type returnType, List<? extends Type> types) {
        return this.specialize(types);
    }
}

