/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IndexLookupSource
implements LookupSource {
    private final IndexLoader indexLoader;
    private IndexSnapshot indexSnapshot;

    public IndexLookupSource(IndexLoader indexLoader) {
        this.indexLoader = (IndexLoader)Preconditions.checkNotNull((Object)indexLoader, (Object)"indexLoader is null");
        this.indexSnapshot = indexLoader.getIndexSnapshot();
    }

    @Override
    public int getChannelCount() {
        return this.indexLoader.getChannelCount();
    }

    @Override
    public long getJoinPosition(int position, Block ... blocks) {
        this.indexSnapshot = this.indexLoader.getIndexSnapshot();
        long joinPosition = this.indexSnapshot.getJoinPosition(position, blocks);
        if (joinPosition == -2L) {
            this.indexSnapshot = this.indexLoader.getIndexSnapshotForKeys(position, blocks);
            joinPosition = this.indexSnapshot.getJoinPosition(position, blocks);
            Preconditions.checkState((joinPosition != -2L ? 1 : 0) != 0);
        }
        return joinPosition;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        long nextPosition = this.indexSnapshot.getNextJoinPosition(currentPosition);
        Preconditions.checkState((nextPosition != -2L ? 1 : 0) != 0);
        return nextPosition;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.indexSnapshot.appendTo(position, pageBuilder, outputChannelOffset);
    }
}

