/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FieldSetFilteringRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final List<Set<Integer>> fieldSets;

    public FieldSetFilteringRecordSet(RecordSet delegate, List<Set<Integer>> fieldSets) {
        this.delegate = (RecordSet)Preconditions.checkNotNull((Object)delegate, (Object)"delegate is null");
        this.fieldSets = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fieldSets, (Object)"fieldSets is null")));
    }

    public List<Type> getColumnTypes() {
        return this.delegate.getColumnTypes();
    }

    public RecordCursor cursor() {
        return new FieldSetFilteringRecordCursor(this.delegate.cursor(), this.fieldSets);
    }

    private static class FieldSetFilteringRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final List<Set<Integer>> fieldSets;

        private FieldSetFilteringRecordCursor(RecordCursor delegate, List<Set<Integer>> fieldSets) {
            this.delegate = delegate;
            this.fieldSets = fieldSets;
        }

        public long getTotalBytes() {
            return this.delegate.getTotalBytes();
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public long getReadTimeNanos() {
            return this.delegate.getReadTimeNanos();
        }

        public Type getType(int field) {
            return this.delegate.getType(field);
        }

        public boolean advanceNextPosition() {
            while (this.delegate.advanceNextPosition()) {
                if (!FieldSetFilteringRecordCursor.fieldSetsEqual(this.delegate, this.fieldSets)) continue;
                return true;
            }
            return false;
        }

        private static boolean fieldSetsEqual(RecordCursor cursor, List<Set<Integer>> fieldSets) {
            for (Set<Integer> fieldSet : fieldSets) {
                if (FieldSetFilteringRecordCursor.fieldsEquals(cursor, fieldSet)) continue;
                return false;
            }
            return true;
        }

        private static boolean fieldsEquals(RecordCursor cursor, Set<Integer> fields) {
            if (fields.size() < 2) {
                return true;
            }
            Iterator<Integer> fieldIterator = fields.iterator();
            int firstField = fieldIterator.next();
            while (fieldIterator.hasNext()) {
                if (FieldSetFilteringRecordCursor.fieldEquals(cursor, firstField, fieldIterator.next())) continue;
                return false;
            }
            return true;
        }

        private static boolean fieldEquals(RecordCursor cursor, int field1, int field2) {
            Preconditions.checkArgument((boolean)cursor.getType(field1).equals(cursor.getType(field2)), (Object)"Should only be comparing fields of the same type");
            if (cursor.isNull(field1) || cursor.isNull(field2)) {
                return false;
            }
            Class javaType = cursor.getType(field1).getJavaType();
            if (javaType == Long.TYPE) {
                return cursor.getLong(field1) == cursor.getLong(field2);
            }
            if (javaType == Double.TYPE) {
                return cursor.getDouble(field1) == cursor.getDouble(field2);
            }
            if (javaType == Boolean.TYPE) {
                return cursor.getBoolean(field1) == cursor.getBoolean(field2);
            }
            if (javaType == Slice.class) {
                return cursor.getSlice(field1).equals((Object)cursor.getSlice(field2));
            }
            throw new IllegalArgumentException("Unknown java type: " + javaType);
        }

        public boolean getBoolean(int field) {
            return this.delegate.getBoolean(field);
        }

        public long getLong(int field) {
            return this.delegate.getLong(field);
        }

        public double getDouble(int field) {
            return this.delegate.getDouble(field);
        }

        public Slice getSlice(int field) {
            return this.delegate.getSlice(field);
        }

        public boolean isNull(int field) {
            return this.delegate.isNull(field);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

