/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.util.array.DoubleBigArray;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;

public class DigestAndPercentileStateFactory
implements AccumulatorStateFactory<DigestAndPercentileState> {
    @Override
    public DigestAndPercentileState createSingleState() {
        return new SingleDigestAndPercentileState();
    }

    @Override
    public Class<? extends DigestAndPercentileState> getSingleStateClass() {
        return SingleDigestAndPercentileState.class;
    }

    @Override
    public DigestAndPercentileState createGroupedState() {
        return new GroupedDigestAndPercentileState();
    }

    @Override
    public Class<? extends DigestAndPercentileState> getGroupedStateClass() {
        return GroupedDigestAndPercentileState.class;
    }

    public static class SingleDigestAndPercentileState
    implements DigestAndPercentileState {
        private QuantileDigest digest;
        private double percentile;

        @Override
        public QuantileDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digest = digest;
        }

        @Override
        public double getPercentile() {
            return this.percentile;
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentile = percentile;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        @Override
        public long getEstimatedSize() {
            if (this.digest == null) {
                return 8L;
            }
            return this.digest.estimatedInMemorySizeInBytes() + 8;
        }
    }

    public static class GroupedDigestAndPercentileState
    extends AbstractGroupedAccumulatorState
    implements DigestAndPercentileState {
        private final ObjectBigArray<QuantileDigest> digests = new ObjectBigArray();
        private final DoubleBigArray percentiles = new DoubleBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
            this.percentiles.ensureCapacity(size);
        }

        @Override
        public QuantileDigest getDigest() {
            return this.digests.get(this.getGroupId());
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            Preconditions.checkNotNull((Object)digest, (Object)"value is null");
            this.digests.set(this.getGroupId(), digest);
        }

        @Override
        public double getPercentile() {
            return this.percentiles.get(this.getGroupId());
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentiles.set(this.getGroupId(), percentile);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        @Override
        public long getEstimatedSize() {
            return this.size + this.digests.sizeOf() + this.percentiles.sizeOf();
        }
    }
}

