/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.GenericAggregationFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.MaxByState;
import com.facebook.presto.operator.aggregation.state.MaxByStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxByStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.List;

public final class MaxByAggregations {
    private static final String NAME = "max_by";
    private static final Method OUTPUT_FUNCTION;
    private static final Method INPUT_FUNCTION;
    private static final Method COMBINE_FUNCTION;

    private MaxByAggregations() {
    }

    public static List<InternalAggregationFunction> getAggregations(TypeManager typeManager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet orderableTypes = FluentIterable.from((Iterable)typeManager.getTypes()).filter((Predicate)new Predicate<Type>(){

            public boolean apply(Type input) {
                return input.isOrderable();
            }
        }).toSet();
        for (Type keyType : orderableTypes) {
            for (Type valueType : typeManager.getTypes()) {
                builder.add((Object)MaxByAggregations.generateAggregation(valueType, keyType));
            }
        }
        return builder.build();
    }

    private static InternalAggregationFunction generateAggregation(Type valueType, Type keyType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MaxByAggregations.class.getClassLoader());
        MaxByStateSerializer stateSerializer = new MaxByStateSerializer();
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        MaxByStateFactory stateFactory = new MaxByStateFactory(valueType, keyType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, valueType, (List<Type>)inputTypes), MaxByAggregations.createInputParameterMetadata(valueType, keyType), INPUT_FUNCTION, null, null, COMBINE_FUNCTION, OUTPUT_FUNCTION, MaxByState.class, stateSerializer, stateFactory, valueType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new GenericAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, valueType, false, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(MaxByState state, Block value, Block key, int position) {
        if (state.getKey() == null || state.getKey().isNull(0)) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        } else if (state.getKeyType().compareTo(key, position, state.getKey(), 0) > 0) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        }
    }

    public static void combine(MaxByState state, MaxByState otherState) {
        if (state.getKey() == null) {
            state.setKey(otherState.getKey());
            state.setValue(otherState.getValue());
        } else if (state.getKeyType().compareTo(otherState.getKey(), 0, state.getKey(), 0) > 0) {
            state.setKey(otherState.getKey());
            state.setValue(otherState.getValue());
        }
    }

    public static void output(MaxByState state, BlockBuilder out) {
        if (state.getValue() == null) {
            out.appendNull();
        } else {
            state.getValueType().appendTo(state.getValue(), 0, out);
        }
    }

    static {
        try {
            OUTPUT_FUNCTION = MaxByAggregations.class.getMethod("output", MaxByState.class, BlockBuilder.class);
            INPUT_FUNCTION = MaxByAggregations.class.getMethod("input", MaxByState.class, Block.class, Block.class, Integer.TYPE);
            COMBINE_FUNCTION = MaxByAggregations.class.getMethod("combine", MaxByState.class, MaxByState.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

