/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.operator.aggregation.state.NullableBigintState;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="max")
public final class LongMaxAggregation {
    public static final InternalAggregationFunction LONG_MAX = new AggregationCompiler().generateAggregationFunction(LongMaxAggregation.class);

    private LongMaxAggregation() {
    }

    @InputFunction
    @IntermediateInputFunction
    public static void max(BigintMaxState state, @SqlType(value="bigint") long value) {
        state.setNull(false);
        state.setLong(Math.max(state.getLong(), value));
    }

    public static interface BigintMaxState
    extends NullableBigintState {
        @Override
        @InitialLongValue(value=-9223372036854775808L)
        public long getLong();
    }
}

