/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.InitialDoubleValue;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="min")
public final class DoubleMinAggregation {
    public static final InternalAggregationFunction DOUBLE_MIN = new AggregationCompiler().generateAggregationFunction(DoubleMinAggregation.class);

    private DoubleMinAggregation() {
    }

    @InputFunction
    @IntermediateInputFunction
    public static void min(DoubleMinState state, @SqlType(value="double") double value) {
        state.setNull(false);
        state.setDouble(Math.min(state.getDouble(), value));
    }

    public static interface DoubleMinState
    extends NullableDoubleState {
        @Override
        @InitialDoubleValue(value=Infinity)
        public double getDouble();
    }
}

