/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.BlockIndex;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.LongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.google.common.collect.ImmutableList;
import java.util.List;

@AggregationFunction(value="count")
public final class CountColumnAggregations {
    public static final InternalAggregationFunction COUNT_BOOLEAN_COLUMN = new AggregationCompiler().generateAggregationFunction(CountColumnAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN));
    public static final InternalAggregationFunction COUNT_LONG_COLUMN = new AggregationCompiler().generateAggregationFunction(CountColumnAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
    public static final InternalAggregationFunction COUNT_VARCHAR_COLUMN = new AggregationCompiler().generateAggregationFunction(CountColumnAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));

    private CountColumnAggregations() {
    }

    @InputFunction
    public static void booleanInput(LongState state, @SqlType(value="boolean") Block block, @BlockIndex int index) {
        state.setLong(state.getLong() + 1L);
    }

    @InputFunction
    public static void doubleInput(LongState state, @SqlType(value="double") Block block, @BlockIndex int index) {
        state.setLong(state.getLong() + 1L);
    }

    @InputFunction
    public static void varcharInput(LongState state, @SqlType(value="varchar") Block block, @BlockIndex int index) {
        state.setLong(state.getLong() + 1L);
    }

    @InputFunction
    public static void bigintInput(LongState state, @SqlType(value="bigint") Block block, @BlockIndex int index) {
        state.setLong(state.getLong() + 1L);
    }

    @CombineFunction
    public static void combine(LongState state, LongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
    }
}

