/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class CountAggregation
implements InternalAggregationFunction {
    public static final CountAggregation COUNT = new CountAggregation();

    @Override
    public String name() {
        return "count";
    }

    @Override
    public List<Type> getParameterTypes() {
        return ImmutableList.of();
    }

    @Override
    public Type getFinalType() {
        return BigintType.BIGINT;
    }

    @Override
    public Type getIntermediateType() {
        return BigintType.BIGINT;
    }

    @Override
    public boolean isDecomposable() {
        return true;
    }

    @Override
    public boolean isApproximate() {
        return false;
    }

    @Override
    public AccumulatorFactory bind(List<Integer> inputChannels, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
        Preconditions.checkArgument((confidence == 1.0 && !sampleWeightChannel.isPresent() ? 1 : 0) != 0, (Object)"approximate not supported for count(*)");
        return new CountAccumulatorFactory(inputChannels, maskChannel);
    }

    public static class CountAccumulatorFactory
    implements AccumulatorFactory {
        private final List<Integer> inputChannels;
        private final Optional<Integer> maskChannel;

        public CountAccumulatorFactory(List<Integer> inputChannels, Optional<Integer> maskChannel) {
            this.inputChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(inputChannels, (Object)"inputChannels is null")));
            this.maskChannel = (Optional)Preconditions.checkNotNull(maskChannel, (Object)"maskChannel is null");
        }

        @Override
        public CountGroupedAccumulator createGroupedAccumulator() {
            return new CountGroupedAccumulator(this.maskChannel);
        }

        @Override
        public GroupedAccumulator createGroupedIntermediateAccumulator() {
            return new CountGroupedAccumulator((Optional<Integer>)Optional.absent());
        }

        @Override
        public List<Integer> getInputChannels() {
            return this.inputChannels;
        }

        @Override
        public CountAccumulator createAccumulator() {
            return new CountAccumulator(this.maskChannel);
        }

        @Override
        public CountAccumulator createIntermediateAccumulator() {
            return new CountAccumulator((Optional<Integer>)Optional.absent());
        }

        public static class CountAccumulator
        implements Accumulator {
            private long count;
            private final Optional<Integer> maskChannel;

            public CountAccumulator(Optional<Integer> maskChannel) {
                this.maskChannel = maskChannel;
            }

            @Override
            public long getEstimatedSize() {
                return 0L;
            }

            @Override
            public Type getFinalType() {
                return BigintType.BIGINT;
            }

            @Override
            public Type getIntermediateType() {
                return BigintType.BIGINT;
            }

            @Override
            public void addInput(Page page) {
                if (!this.maskChannel.isPresent()) {
                    this.count += (long)page.getPositionCount();
                } else {
                    Block masks = page.getBlock((Integer)this.maskChannel.get());
                    for (int position = 0; position < page.getPositionCount(); ++position) {
                        if (masks != null && !BooleanType.BOOLEAN.getBoolean(masks, position)) continue;
                        ++this.count;
                    }
                }
            }

            @Override
            public void addIntermediate(Block intermediates) {
                for (int position = 0; position < intermediates.getPositionCount(); ++position) {
                    this.count += BigintType.BIGINT.getLong(intermediates, position);
                }
            }

            @Override
            public final Block evaluateIntermediate() {
                return this.evaluateFinal();
            }

            @Override
            public final Block evaluateFinal() {
                BlockBuilder out = this.getFinalType().createBlockBuilder(new BlockBuilderStatus());
                BigintType.BIGINT.writeLong(out, this.count);
                return out.build();
            }
        }

        public static class CountGroupedAccumulator
        implements GroupedAccumulator {
            private final LongBigArray counts = new LongBigArray();
            private final Optional<Integer> maskChannel;

            public CountGroupedAccumulator(Optional<Integer> maskChannel) {
                this.maskChannel = maskChannel;
            }

            @Override
            public long getEstimatedSize() {
                return this.counts.sizeOf();
            }

            @Override
            public Type getFinalType() {
                return BigintType.BIGINT;
            }

            @Override
            public Type getIntermediateType() {
                return BigintType.BIGINT;
            }

            @Override
            public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
                this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
                Block masks = this.maskChannel.isPresent() ? page.getBlock((Integer)this.maskChannel.get()) : null;
                for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                    long groupId = groupIdsBlock.getGroupId(position);
                    if (masks != null && !BooleanType.BOOLEAN.getBoolean(masks, position)) continue;
                    this.counts.increment(groupId);
                }
            }

            @Override
            public void addIntermediate(GroupByIdBlock groupIdsBlock, Block intermediates) {
                this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
                for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                    long groupId = groupIdsBlock.getGroupId(position);
                    this.counts.add(groupId, BigintType.BIGINT.getLong(intermediates, position));
                }
            }

            @Override
            public void evaluateIntermediate(int groupId, BlockBuilder output) {
                this.evaluateFinal(groupId, output);
            }

            @Override
            public void evaluateFinal(int groupId, BlockBuilder output) {
                long value = this.counts.get(groupId);
                BigintType.BIGINT.writeLong(output, value);
            }
        }
    }
}

