/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.BlockIndex;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.SampleWeight;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;

@AggregationFunction(value="count", approximate=true)
public final class ApproximateCountColumnAggregations {
    public static final InternalAggregationFunction BOOLEAN_APPROXIMATE_COUNT_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateCountColumnAggregations.class, (Type)VarcharType.VARCHAR, (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN));
    public static final InternalAggregationFunction LONG_APPROXIMATE_COUNT_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateCountColumnAggregations.class, (Type)VarcharType.VARCHAR, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_COUNT_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateCountColumnAggregations.class, (Type)VarcharType.VARCHAR, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction VARBINARY_APPROXIMATE_COUNT_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateCountColumnAggregations.class, (Type)VarcharType.VARCHAR, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));

    private ApproximateCountColumnAggregations() {
    }

    @InputFunction
    public static void booleanInput(ApproximateCountState state, @SqlType(value="boolean") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @InputFunction
    public static void bigintInput(ApproximateCountState state, @SqlType(value="bigint") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @InputFunction
    public static void doubleInput(ApproximateCountState state, @SqlType(value="double") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @InputFunction
    public static void varcharInput(ApproximateCountState state, @SqlType(value="varchar") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @CombineFunction
    public static void combine(ApproximateCountState state, ApproximateCountState otherState) {
        state.setCount(state.getCount() + otherState.getCount());
        state.setSamples(state.getSamples() + otherState.getSamples());
    }

    @OutputFunction(value="varchar")
    public static void output(ApproximateCountState state, double confidence, BlockBuilder out) {
        String result = ApproximateUtils.formatApproximateResult(state.getCount(), ApproximateUtils.countError(state.getSamples(), state.getCount()), confidence, true);
        VarcharType.VARCHAR.writeSlice(out, Slices.utf8Slice((String)result));
    }

    public static interface ApproximateCountState
    extends AccumulatorState {
        public long getCount();

        public void setCount(long var1);

        public long getSamples();

        public void setSamples(long var1);
    }
}

