/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;

public class ApproximateCountAggregation
implements InternalAggregationFunction {
    public static final ApproximateCountAggregation APPROXIMATE_COUNT_AGGREGATION = new ApproximateCountAggregation();
    private static final int COUNT_OFFSET = 0;
    private static final int SAMPLES_OFFSET = 8;

    @Override
    public String name() {
        return "count";
    }

    @Override
    public List<Type> getParameterTypes() {
        return ImmutableList.of();
    }

    @Override
    public Type getFinalType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public Type getIntermediateType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public boolean isDecomposable() {
        return true;
    }

    @Override
    public boolean isApproximate() {
        return true;
    }

    @Override
    public AccumulatorFactory bind(List<Integer> inputChannels, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
        return new ApproximateCountAccumulatorFactory(inputChannels, maskChannel, sampleWeightChannel, confidence);
    }

    public static class ApproximateCountAccumulatorFactory
    implements AccumulatorFactory {
        private final List<Integer> inputChannels;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;
        private final double confidence;

        public ApproximateCountAccumulatorFactory(List<Integer> inputChannels, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            this.inputChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(inputChannels, (Object)"inputChannels is null")));
            this.maskChannel = (Optional)Preconditions.checkNotNull(maskChannel, (Object)"maskChannel is null");
            this.sampleWeightChannel = (Optional)Preconditions.checkNotNull(sampleWeightChannel, (Object)"sampleWeightChannel is null");
            this.confidence = confidence;
        }

        @Override
        public ApproximateCountGroupedAccumulator createGroupedAccumulator() {
            Preconditions.checkArgument((boolean)this.sampleWeightChannel.isPresent(), (Object)"sampleWeightChannel missing");
            return new ApproximateCountGroupedAccumulator(this.maskChannel, (Integer)this.sampleWeightChannel.get(), this.confidence);
        }

        @Override
        public GroupedAccumulator createGroupedIntermediateAccumulator() {
            return new ApproximateCountGroupedAccumulator((Optional<Integer>)Optional.absent(), -1, this.confidence);
        }

        @Override
        public List<Integer> getInputChannels() {
            return this.inputChannels;
        }

        @Override
        public CountAccumulator createAccumulator() {
            Preconditions.checkArgument((boolean)this.sampleWeightChannel.isPresent(), (Object)"sampleWeightChannel missing");
            return new CountAccumulator(this.maskChannel, (Integer)this.sampleWeightChannel.get(), this.confidence);
        }

        @Override
        public CountAccumulator createIntermediateAccumulator() {
            return new CountAccumulator((Optional<Integer>)Optional.absent(), -1, this.confidence);
        }

        public static Slice createIntermediate(long count, long samples) {
            Slice slice = Slices.allocate((int)16);
            slice.setLong(0, count);
            slice.setLong(8, samples);
            return slice;
        }

        public static class CountAccumulator
        implements Accumulator {
            private long count;
            private long samples;
            private final Optional<Integer> maskChannel;
            private final int sampleWeightChannel;
            private final double confidence;

            public CountAccumulator(Optional<Integer> maskChannel, int sampleWeightChannel, double confidence) {
                this.maskChannel = maskChannel;
                this.sampleWeightChannel = sampleWeightChannel;
                this.confidence = confidence;
            }

            @Override
            public long getEstimatedSize() {
                return 36L;
            }

            @Override
            public Type getFinalType() {
                return VarcharType.VARCHAR;
            }

            @Override
            public Type getIntermediateType() {
                return VarcharType.VARCHAR;
            }

            @Override
            public void addInput(Page page) {
                Block masks = null;
                if (this.maskChannel.isPresent()) {
                    masks = page.getBlock((Integer)this.maskChannel.get());
                }
                Block sampleWeights = page.getBlock(this.sampleWeightChannel);
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    long weight = ApproximateUtils.computeSampleWeight(masks, sampleWeights, position);
                    this.count += weight;
                    if (weight <= 0L) continue;
                    ++this.samples;
                }
            }

            @Override
            public void addIntermediate(Block intermediates) {
                for (int position = 0; position < intermediates.getPositionCount(); ++position) {
                    Slice slice = VarcharType.VARCHAR.getSlice(intermediates, position);
                    this.count += slice.getLong(0);
                    this.samples += slice.getLong(8);
                }
            }

            @Override
            public final Block evaluateIntermediate() {
                BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
                VarcharType.VARCHAR.writeSlice(blockBuilder, ApproximateCountAccumulatorFactory.createIntermediate(this.count, this.samples));
                return blockBuilder.build();
            }

            @Override
            public final Block evaluateFinal() {
                Slice value = Slices.utf8Slice((String)ApproximateUtils.formatApproximateResult(this.count, ApproximateUtils.countError(this.samples, this.count), this.confidence, true));
                Type finalType = this.getFinalType();
                BlockBuilder blockBuilder = finalType.createBlockBuilder(new BlockBuilderStatus());
                finalType.writeSlice(blockBuilder, value, 0, value.length());
                return blockBuilder.build();
            }
        }

        public static class ApproximateCountGroupedAccumulator
        implements GroupedAccumulator {
            private final LongBigArray counts = new LongBigArray();
            private final LongBigArray samples = new LongBigArray();
            private final Optional<Integer> maskChannel;
            private final int sampleWeightChannel;
            private final double confidence;

            public ApproximateCountGroupedAccumulator(Optional<Integer> maskChannel, int sampleWeightChannel, double confidence) {
                this.maskChannel = maskChannel;
                this.sampleWeightChannel = sampleWeightChannel;
                this.confidence = confidence;
            }

            @Override
            public long getEstimatedSize() {
                return this.counts.sizeOf() + this.samples.sizeOf();
            }

            @Override
            public Type getFinalType() {
                return VarcharType.VARCHAR;
            }

            @Override
            public Type getIntermediateType() {
                return VarcharType.VARCHAR;
            }

            @Override
            public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
                this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
                this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
                Block masks = null;
                if (this.maskChannel.isPresent()) {
                    masks = page.getBlock((Integer)this.maskChannel.get());
                }
                Block sampleWeights = page.getBlock(this.sampleWeightChannel);
                for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                    long groupId = groupIdsBlock.getGroupId(position);
                    long weight = ApproximateUtils.computeSampleWeight(masks, sampleWeights, position);
                    this.counts.add(groupId, weight);
                    if (weight <= 0L) continue;
                    this.samples.increment(groupId);
                }
            }

            @Override
            public void addIntermediate(GroupByIdBlock groupIdsBlock, Block intermediates) {
                this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
                this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
                for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                    long groupId = groupIdsBlock.getGroupId(position);
                    Slice slice = VarcharType.VARCHAR.getSlice(intermediates, position);
                    this.counts.add(groupId, slice.getLong(0));
                    this.samples.add(groupId, slice.getLong(8));
                }
            }

            @Override
            public void evaluateIntermediate(int groupId, BlockBuilder output) {
                VarcharType.VARCHAR.writeSlice(output, ApproximateCountAccumulatorFactory.createIntermediate(this.counts.get(groupId), this.samples.get(groupId)));
            }

            @Override
            public void evaluateFinal(int groupId, BlockBuilder output) {
                long count = this.counts.get(groupId);
                long samples = this.samples.get(groupId);
                String result = ApproximateUtils.formatApproximateResult(count, ApproximateUtils.countError(samples, count), this.confidence, true);
                VarcharType.VARCHAR.writeString(output, result);
            }
        }
    }
}

