/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class TableWriterOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
    private final OperatorContext operatorContext;
    private final RecordSink recordSink;
    private final Optional<Integer> sampleWeightChannel;
    private final List<Type> recordTypes;
    private final List<Integer> inputChannels;
    private State state = State.RUNNING;
    private long rowCount;

    public TableWriterOperator(OperatorContext operatorContext, RecordSink recordSink, List<Type> recordTypes, List<Integer> inputChannels, Optional<Integer> sampleWeightChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.recordSink = (RecordSink)Preconditions.checkNotNull((Object)recordSink, (Object)"recordSink is null");
        this.recordTypes = recordTypes;
        this.sampleWeightChannel = (Optional)Preconditions.checkNotNull(sampleWeightChannel, (Object)"sampleWeightChannel is null");
        this.inputChannels = (List)Preconditions.checkNotNull(inputChannels, (Object)"inputChannels is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object[])new Object[]{this.state});
        Block sampleWeightBlock = null;
        if (this.sampleWeightChannel.isPresent()) {
            sampleWeightBlock = page.getBlock((Integer)this.sampleWeightChannel.get());
        }
        Block[] blocks = new Block[this.inputChannels.size()];
        for (int outputChannel = 0; outputChannel < this.inputChannels.size(); ++outputChannel) {
            blocks[outputChannel] = page.getBlock(this.inputChannels.get(outputChannel));
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            long sampleWeight = 1L;
            if (sampleWeightBlock != null) {
                sampleWeight = BigintType.BIGINT.getLong(sampleWeightBlock, position);
            }
            this.recordSink.beginRecord(sampleWeight);
            for (int i = 0; i < blocks.length; ++i) {
                this.writeField(position, blocks[i], this.recordTypes.get(i));
            }
            this.recordSink.finishRecord();
        }
        this.rowCount += (long)page.getPositionCount();
    }

    private void writeField(int position, Block block, Type type) {
        if (block.isNull(position)) {
            this.recordSink.appendNull();
            return;
        }
        if (type.getJavaType() == Boolean.TYPE) {
            this.recordSink.appendBoolean(type.getBoolean(block, position));
        } else if (type.getJavaType() == Long.TYPE) {
            this.recordSink.appendLong(type.getLong(block, position));
        } else if (type.getJavaType() == Double.TYPE) {
            this.recordSink.appendDouble(type.getDouble(block, position));
        } else if (type.getJavaType() == Slice.class) {
            this.recordSink.appendString(type.getSlice(block, position).getBytes());
        } else {
            throw new AssertionError((Object)("unimplemented type: " + type));
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        String fragment = this.recordSink.commit();
        PageBuilder page = new PageBuilder(TYPES);
        BigintType.BIGINT.writeLong(page.getBlockBuilder(0), this.rowCount);
        VarcharType.VARCHAR.writeSlice(page.getBlockBuilder(1), Slices.utf8Slice((String)fragment));
        return page.build();
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final RecordSink recordSink;
        private final List<Integer> inputChannels;
        private final List<Type> recordTypes;
        private final Optional<Integer> sampleWeightChannel;
        private boolean closed;

        public TableWriterOperatorFactory(int operatorId, RecordSink recordSink, List<Type> recordTypes, List<Integer> inputChannels, Optional<Integer> sampleWeightChannel) {
            this.operatorId = operatorId;
            this.inputChannels = (List)Preconditions.checkNotNull(inputChannels, (Object)"inputChannels is null");
            this.recordSink = (RecordSink)Preconditions.checkNotNull((Object)recordSink, (Object)"recordSink is null");
            Preconditions.checkNotNull(recordTypes, (Object)"types is null");
            this.recordTypes = ImmutableList.copyOf((Iterable)Iterables.transform(recordTypes, (Function)new Function<Type, Type>(){

                public Type apply(Type type) {
                    return type;
                }
            }));
            this.sampleWeightChannel = (Optional)Preconditions.checkNotNull(sampleWeightChannel, (Object)"sampleWeightChannel is null");
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, TableWriterOperator.class.getSimpleName());
            return new TableWriterOperator(context, this.recordSink, this.recordTypes, this.inputChannels, this.sampleWeightChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

