/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FinishedOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class TableScanOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final DataStreamProvider dataStreamProvider;
    private final List<Type> types;
    private final List<ColumnHandle> columns;
    private final SettableFuture<?> blocked;
    @GuardedBy(value="this")
    private Operator source;

    public TableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, DataStreamProvider dataStreamProvider, List<Type> types, Iterable<ColumnHandle> columns) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)planNodeId, (Object)"planNodeId is null");
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
        this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.blocked = SettableFuture.create();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public synchronized void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkState((this.getSource() == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        this.source = this.dataStreamProvider.createNewDataStream(this.operatorContext, split, this.columns);
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)splitInfo));
        }
        this.blocked.set(null);
    }

    @Override
    public synchronized void noMoreSplits() {
        if (this.source == null) {
            this.source = new FinishedOperator(this.operatorContext, this.types);
        }
    }

    private synchronized Operator getSource() {
        return this.source;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        Operator delegate = this.getSource();
        if (delegate == null) {
            return;
        }
        delegate.finish();
    }

    @Override
    public boolean isFinished() {
        Operator delegate = this.getSource();
        return delegate != null && delegate.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        Operator delegate = this.getSource();
        if (delegate != null) {
            return delegate.isBlocked();
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        Operator delegate = this.getSource();
        if (delegate == null) {
            return null;
        }
        return delegate.getOutput();
    }

    public static class TableScanOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DataStreamProvider dataStreamProvider;
        private final List<Type> types;
        private final List<ColumnHandle> columns;
        private boolean closed;

        public TableScanOperatorFactory(int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, List<Type> types, Iterable<ColumnHandle> columns) {
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
            this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
            this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TableScanOperator.class.getSimpleName());
            return new TableScanOperator(operatorContext, this.sourceId, this.dataStreamProvider, this.types, this.columns);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

