/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.RecordProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class ScanFilterAndProjectOperator
implements SourceOperator,
Closeable {
    private static final int ROWS_PER_PAGE = 16384;
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final DataStreamProvider dataStreamProvider;
    private final List<Type> types;
    private final List<ColumnHandle> columns;
    private final PageBuilder pageBuilder;
    private final CursorProcessor cursorProcessor;
    private final PageProcessor pageProcessor;
    @GuardedBy(value="this")
    private RecordCursor cursor;
    @GuardedBy(value="this")
    private Operator operator;
    private Page currentPage;
    private int currentPosition;
    private boolean finishing;
    private long completedBytes;
    private long readTimeNanos;

    protected ScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, Iterable<ColumnHandle> columns, Iterable<Type> types) {
        this.cursorProcessor = (CursorProcessor)Preconditions.checkNotNull((Object)cursorProcessor, (Object)"cursorProcessor is null");
        this.pageProcessor = (PageProcessor)Preconditions.checkNotNull((Object)pageProcessor, (Object)"pageProcessor is null");
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
        this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
        this.types = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public synchronized void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkState((this.cursor == null && this.operator == null ? 1 : 0) != 0, (Object)"split already set");
        Operator dataStream = this.dataStreamProvider.createNewDataStream(this.operatorContext, split, this.columns);
        if (dataStream instanceof RecordProjectOperator) {
            this.cursor = ((RecordProjectOperator)dataStream).getCursor();
        } else {
            this.operator = dataStream;
        }
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)splitInfo));
        }
    }

    @Override
    public synchronized void noMoreSplits() {
        if (this.cursor == null && this.operator == null) {
            this.finishing = true;
        }
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public void close() {
        if (this.operator != null) {
            this.operator.finish();
        } else if (this.cursor != null) {
            this.cursor.close();
        }
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        if (this.operator != null && this.operator.isFinished()) {
            this.finishing = true;
        }
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.operator != null) {
            return this.operator.isBlocked();
        }
        return NOT_BLOCKED;
    }

    @Override
    public final boolean needsInput() {
        return false;
    }

    @Override
    public final void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            if (this.cursor != null) {
                int rowsProcessed = this.cursorProcessor.process(this.operatorContext.getSession(), this.cursor, 16384, this.pageBuilder);
                long bytesProcessed = this.cursor.getCompletedBytes() - this.completedBytes;
                long elapsedNanos = this.cursor.getReadTimeNanos() - this.readTimeNanos;
                this.operatorContext.recordGeneratedInput(new DataSize((double)bytesProcessed, DataSize.Unit.BYTE), rowsProcessed, elapsedNanos);
                this.completedBytes = this.cursor.getCompletedBytes();
                this.readTimeNanos = this.cursor.getReadTimeNanos();
                if (rowsProcessed == 0) {
                    this.finishing = true;
                }
            } else {
                if (this.currentPage == null) {
                    this.currentPage = this.operator.getOutput();
                    this.currentPosition = 0;
                }
                if (this.currentPage != null) {
                    this.currentPosition = this.pageProcessor.process(this.operatorContext.getSession(), this.currentPage, this.currentPosition, this.currentPage.getPositionCount(), this.pageBuilder);
                    if (this.currentPosition == this.currentPage.getPositionCount()) {
                        this.currentPage = null;
                        this.currentPosition = 0;
                    }
                }
            }
        }
        if (this.pageBuilder.isEmpty() || !this.finishing && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final CursorProcessor cursorProcessor;
        private final PageProcessor pageProcessor;
        private final PlanNodeId sourceId;
        private final DataStreamProvider dataStreamProvider;
        private final List<ColumnHandle> columns;
        private final List<Type> types;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, Iterable<ColumnHandle> columns, List<Type> types) {
            this.operatorId = operatorId;
            this.cursorProcessor = (CursorProcessor)Preconditions.checkNotNull((Object)cursorProcessor, (Object)"cursorProcessor is null");
            this.pageProcessor = (PageProcessor)Preconditions.checkNotNull((Object)pageProcessor, (Object)"pageProcessor is null");
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
            this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
            this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, FilterAndProjectOperator.class.getSimpleName());
            return new ScanFilterAndProjectOperator(operatorContext, this.sourceId, this.dataStreamProvider, this.cursorProcessor, this.pageProcessor, this.columns, this.types);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

