/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;

public class RowNumberLimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private boolean finishing;
    private final PageBuilder pageBuilder;
    private final int[] outputChannels;
    private final List<Type> types;
    private GroupByIdBlock partitionIds;
    private final GroupByHash groupByHash;
    private Page inputPage;
    private int currentPosition;
    private final int maxRowCountPerPartition;
    private final LongBigArray partitionRowCount;

    public RowNumberLimitOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, int expectedPositions, int maxRowCountPerPartition) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.outputChannels = Ints.toArray(outputChannels);
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.partitionRowCount = new LongBigArray(0L);
        this.groupByHash = new GroupByHash(partitionTypes, Ints.toArray(partitionChannels), expectedPositions);
        this.types = RowNumberLimitOperator.toTypes(sourceTypes, outputChannels);
        this.pageBuilder = new PageBuilder(this.types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.inputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.inputPage == null ? 1 : 0) != 0);
        this.inputPage = page;
        this.partitionIds = this.groupByHash.getGroupIds(this.inputPage);
        this.partitionRowCount.ensureCapacity(this.partitionIds.getGroupCount());
        this.currentPosition = 0;
    }

    @Override
    public Page getOutput() {
        if (this.inputPage == null) {
            return null;
        }
        while (!this.pageBuilder.isFull() && this.currentPosition < this.inputPage.getPositionCount()) {
            long partitionId = this.partitionIds.getGroupId(this.currentPosition);
            long rowCount = this.partitionRowCount.get(partitionId);
            if (rowCount < (long)this.maxRowCountPerPartition) {
                for (int i = 0; i < this.outputChannels.length; ++i) {
                    int channel = this.outputChannels[i];
                    Type type = this.types.get(channel);
                    type.appendTo(this.inputPage.getBlock(channel), this.currentPosition, this.pageBuilder.getBlockBuilder(i));
                }
                BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(this.types.size() - 1), rowCount + 1L);
                this.partitionRowCount.set(partitionId, rowCount + 1L);
            }
            ++this.currentPosition;
        }
        if (this.currentPosition == this.inputPage.getPositionCount()) {
            this.inputPage = null;
            this.currentPosition = 0;
        }
        if (this.pageBuilder.isEmpty()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        types.add((Object)BigintType.BIGINT);
        return types.build();
    }

    public static class RowNumberLimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final int expectedPositions;
        private final List<Type> types;
        private boolean closed;
        private final List<Type> partitionTypes;
        private final int maxRowCountPerPartition;

        public RowNumberLimitOperatorFactory(int operatorId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, int expectedPositions, int maxRowCountPerPartition) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputChannels, (Object)"outputChannels is null")));
            this.partitionChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionChannels, (Object)"partitionChannels is null")));
            this.partitionTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionTypes, (Object)"partitionTypes is null")));
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions < 0");
            this.expectedPositions = expectedPositions;
            Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition < 0");
            this.maxRowCountPerPartition = maxRowCountPerPartition;
            this.types = RowNumberLimitOperator.toTypes(sourceTypes, outputChannels);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, RowNumberLimitOperator.class.getSimpleName());
            return new RowNumberLimitOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.expectedPositions, this.maxRowCountPerPartition);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

