/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class LimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private Page nextPage;
    private long remainingLimit;

    public LimitOperator(OperatorContext operatorContext, List<Type> types, long limit) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.remainingLimit = 0L;
    }

    @Override
    public boolean isFinished() {
        return this.remainingLimit == 0L && this.nextPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.remainingLimit > 0L && this.nextPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        if ((long)page.getPositionCount() <= this.remainingLimit) {
            this.remainingLimit -= (long)page.getPositionCount();
            this.nextPage = page;
        } else {
            Block[] blocks = new Block[page.getChannelCount()];
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Block block = page.getBlock(channel);
                blocks[channel] = block.getRegion(0, (int)this.remainingLimit);
            }
            this.nextPage = new Page((int)this.remainingLimit, blocks);
            this.remainingLimit = 0L;
        }
    }

    @Override
    public Page getOutput() {
        Page page = this.nextPage;
        this.nextPage = null;
        return page;
    }

    public static class LimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> types;
        private final long limit;
        private boolean closed;

        public LimitOperatorFactory(int operatorId, List<? extends Type> types, long limit) {
            this.operatorId = operatorId;
            this.types = ImmutableList.copyOf(types);
            this.limit = limit;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, LimitOperator.class.getSimpleName());
            return new LimitOperator(operatorContext, this.types, this.limit);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

