/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.MemoryManager;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HashAggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final AggregationNode.Step step;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final int expectedGroups;
    private final List<Type> types;
    private final MemoryManager memoryManager;
    private GroupByHashAggregationBuilder aggregationBuilder;
    private Iterator<Page> outputIterator;
    private boolean finishing;

    public HashAggregationOperator(OperatorContext operatorContext, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, int expectedGroups) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
        Preconditions.checkNotNull(accumulatorFactories, (Object)"accumulatorFactories is null");
        Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.groupByTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = ImmutableList.copyOf(groupByChannels);
        this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.memoryManager = new MemoryManager(operatorContext);
        this.types = HashAggregationOperator.toTypes(groupByTypes, step, accumulatorFactories);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.aggregationBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.aggregationBuilder == null || !this.aggregationBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.aggregationBuilder == null) {
            this.aggregationBuilder = new GroupByHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.memoryManager);
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        this.aggregationBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.aggregationBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.aggregationBuilder.isFull()) {
                return null;
            }
            if (!this.finishing && this.step != AggregationNode.Step.PARTIAL) {
                throw new ExceededMemoryLimitException(this.memoryManager.getMaxMemorySize());
            }
            this.outputIterator = this.aggregationBuilder.build();
            this.aggregationBuilder = null;
            if (!this.outputIterator.hasNext()) {
                return null;
            }
        }
        return this.outputIterator.next();
    }

    private static List<Type> toTypes(List<? extends Type> groupByType, AggregationNode.Step step, List<AccumulatorFactory> factories) {
        ImmutableList.Builder types = ImmutableList.builder();
        types.addAll(groupByType);
        for (AccumulatorFactory factory : factories) {
            types.add((Object)new Aggregator(factory, step).getType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final GroupedAccumulator aggregation;
        private final AggregationNode.Step step;
        private final int intermediateChannel;

        private Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step) {
            if (step == AggregationNode.Step.FINAL) {
                Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
                this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator();
            } else {
                this.intermediateChannel = -1;
                this.aggregation = accumulatorFactory.createGroupedAccumulator();
            }
            this.step = step;
        }

        public long getEstimatedSize() {
            return this.aggregation.getEstimatedSize();
        }

        public Type getType() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(GroupByIdBlock groupIds, Page page) {
            if (this.step == AggregationNode.Step.FINAL) {
                this.aggregation.addIntermediate(groupIds, page.getBlock(this.intermediateChannel));
            } else {
                this.aggregation.addInput(groupIds, page);
            }
        }

        public void evaluate(int groupId, BlockBuilder output) {
            if (this.step == AggregationNode.Step.PARTIAL) {
                this.aggregation.evaluateIntermediate(groupId, output);
            } else {
                this.aggregation.evaluateFinal(groupId, output);
            }
        }
    }

    private static class GroupByHashAggregationBuilder {
        private final GroupByHash groupByHash;
        private final List<Aggregator> aggregators;
        private final MemoryManager memoryManager;

        private GroupByHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, MemoryManager memoryManager) {
            this.groupByHash = new GroupByHash(groupByTypes, Ints.toArray(groupByChannels), expectedGroups);
            this.memoryManager = memoryManager;
            ImmutableList.Builder builder = ImmutableList.builder();
            Preconditions.checkNotNull(accumulatorFactories, (Object)"accumulatorFactories is null");
            for (int i = 0; i < accumulatorFactories.size(); ++i) {
                AccumulatorFactory accumulatorFactory = accumulatorFactories.get(i);
                builder.add((Object)new Aggregator(accumulatorFactory, step));
            }
            this.aggregators = builder.build();
        }

        private void processPage(Page page) {
            GroupByIdBlock groupIds = this.groupByHash.getGroupIds(page);
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage(groupIds, page);
            }
        }

        public boolean isFull() {
            long memorySize = this.groupByHash.getEstimatedSize();
            for (Aggregator aggregator : this.aggregators) {
                memorySize += aggregator.getEstimatedSize();
            }
            return !this.memoryManager.canUse(memorySize);
        }

        public Iterator<Page> build() {
            ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
            for (Aggregator aggregator : this.aggregators) {
                types.add(aggregator.getType());
            }
            final PageBuilder pageBuilder = new PageBuilder(types);
            return new AbstractIterator<Page>(){
                private final int groupCount;
                private int groupId;
                {
                    this.groupCount = GroupByHashAggregationBuilder.this.groupByHash.getGroupCount();
                }

                protected Page computeNext() {
                    if (this.groupId >= this.groupCount) {
                        return (Page)this.endOfData();
                    }
                    pageBuilder.reset();
                    List<Type> types = GroupByHashAggregationBuilder.this.groupByHash.getTypes();
                    while (!pageBuilder.isFull() && this.groupId < this.groupCount) {
                        GroupByHashAggregationBuilder.this.groupByHash.appendValuesTo(this.groupId, pageBuilder, 0);
                        for (int i = 0; i < GroupByHashAggregationBuilder.this.aggregators.size(); ++i) {
                            Aggregator aggregator = (Aggregator)GroupByHashAggregationBuilder.this.aggregators.get(i);
                            BlockBuilder output = pageBuilder.getBlockBuilder(types.size() + i);
                            aggregator.evaluate(this.groupId, output);
                        }
                        ++this.groupId;
                    }
                    return pageBuilder.build();
                }
            };
        }
    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final AggregationNode.Step step;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final int expectedGroups;
        private final List<Type> types;
        private boolean closed;

        public HashAggregationOperatorFactory(int operatorId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, int expectedGroups) {
            this.operatorId = operatorId;
            this.groupByTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = ImmutableList.copyOf(groupByChannels);
            this.step = step;
            this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
            this.expectedGroups = expectedGroups;
            this.types = HashAggregationOperator.toTypes(groupByTypes, step, accumulatorFactories);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashAggregationOperator.class.getSimpleName());
            return new HashAggregationOperator(operatorContext, this.groupByTypes, this.groupByChannels, this.step, this.accumulatorFactories, this.expectedGroups);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

