/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Murmur3;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GroupByHash {
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler();
    private static final float FILL_RATIO = 0.75f;
    private final List<Type> types;
    private final int[] channels;
    private final PagesHashStrategy hashStrategy;
    private final List<ObjectArrayList<Block>> channelBuilders;
    private PageBuilder currentPageBuilder;
    private long completedPagesMemorySize;
    private int maxFill;
    private int mask;
    private long[] key;
    private int[] value;
    private final LongBigArray groupAddress;
    private int nextGroupId;

    public GroupByHash(List<? extends Type> types, int[] channels, int expectedSize) {
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.channels = (int[])((int[])Preconditions.checkNotNull((Object)channels, (Object)"channels is null")).clone();
        Preconditions.checkArgument((types.size() == channels.length ? 1 : 0) != 0, (Object)"types and channels have different sizes");
        ImmutableList.Builder hashChannels = ImmutableList.builder();
        ImmutableList.Builder channelBuilders = ImmutableList.builder();
        for (int i = 0; i < channels.length; ++i) {
            hashChannels.add((Object)i);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        }
        this.channelBuilders = channelBuilders.build();
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = JOIN_COMPILER.compilePagesHashStrategyFactory(this.types, (List<Integer>)hashChannels.build());
        this.hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy(this.channelBuilders);
        this.startNewPage();
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = HashCommon.maxFill((int)hashSize, (float)0.75f);
        this.mask = hashSize - 1;
        this.key = new long[hashSize];
        Arrays.fill(this.key, -1L);
        this.value = new int[hashSize];
        this.groupAddress = new LongBigArray();
        this.groupAddress.ensureCapacity(this.maxFill);
    }

    public long getEstimatedSize() {
        return SizeOf.sizeOf((Object[])this.channelBuilders.get(0).elements()) * (long)this.channelBuilders.size() + this.completedPagesMemorySize + this.currentPageBuilder.getSizeInBytes() + SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value) + this.groupAddress.sizeOf();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getGroupCount() {
        return this.nextGroupId;
    }

    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        long address = this.groupAddress.get(groupId);
        int blockIndex = SyntheticAddress.decodeSliceIndex(address);
        int position = SyntheticAddress.decodePosition(address);
        this.hashStrategy.appendTo(blockIndex, position, pageBuilder, outputChannelOffset);
    }

    public GroupByIdBlock getGroupIds(Page page) {
        int positionCount = page.getPositionCount();
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Block[] blocks = new Block[this.channels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            blocks[i] = page.getBlock(this.channels[i]);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int groupId = this.putIfAbsent(position, blocks);
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        Block block = blockBuilder.build();
        return new GroupByIdBlock(this.nextGroupId, block);
    }

    public boolean contains(int position, Block ... blocks) {
        int hashPosition = (int)Murmur3.hash64((long)this.hashStrategy.hashRow(position, blocks)) & this.mask;
        while (this.key[hashPosition] != -1L) {
            long address = this.key[hashPosition];
            if (this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), position, blocks)) {
                return true;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        return false;
    }

    public int putIfAbsent(int position, Block ... blocks) {
        int hashPosition = (int)Murmur3.hash64((long)this.hashStrategy.hashRow(position, blocks)) & this.mask;
        int groupId = -1;
        while (this.key[hashPosition] != -1L) {
            long address = this.key[hashPosition];
            if (this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), position, blocks)) {
                groupId = this.value[hashPosition];
                break;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        if (groupId < 0) {
            groupId = this.addNewGroup(hashPosition, position, blocks);
        }
        return groupId;
    }

    private int addNewGroup(int hashPosition, int position, Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            Type type = this.types.get(i);
            type.appendTo(blocks[i], position, this.currentPageBuilder.getBlockBuilder(i));
        }
        this.currentPageBuilder.declarePosition();
        int pageIndex = this.channelBuilders.get(0).size() - 1;
        int pagePosition = this.currentPageBuilder.getPositionCount() - 1;
        long address = SyntheticAddress.encodeSyntheticAddress(pageIndex, pagePosition);
        int groupId = this.nextGroupId++;
        this.key[hashPosition] = address;
        this.value[hashPosition] = groupId;
        this.groupAddress.set(groupId, address);
        if (this.currentPageBuilder.isFull()) {
            this.startNewPage();
        }
        if (this.nextGroupId >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return groupId;
    }

    private void startNewPage() {
        if (this.currentPageBuilder != null) {
            this.completedPagesMemorySize += this.currentPageBuilder.getSizeInBytes();
        }
        this.currentPageBuilder = new PageBuilder(this.types);
        for (int i = 0; i < this.types.size(); ++i) {
            this.channelBuilders.get(i).add((Object)this.currentPageBuilder.getBlockBuilder(i));
        }
    }

    private void rehash(int size) {
        int newSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        int newMask = newSize - 1;
        long[] newKey = new long[newSize];
        Arrays.fill(newKey, -1L);
        int[] newValue = new int[newSize];
        int oldIndex = 0;
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            while (this.key[oldIndex] == -1L) {
                ++oldIndex;
            }
            long address = this.key[oldIndex];
            int pos = (int)Murmur3.hash64((long)this.hashPosition(address)) & newMask;
            while (newKey[pos] != -1L) {
                pos = pos + 1 & newMask;
            }
            newKey[pos] = address;
            newValue[pos] = this.value[oldIndex];
            ++oldIndex;
        }
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill((int)newSize, (float)0.75f);
        this.key = newKey;
        this.value = newValue;
        this.groupAddress.ensureCapacity(this.maxFill);
    }

    private int hashPosition(long sliceAddress) {
        int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
        int position = SyntheticAddress.decodePosition(sliceAddress);
        return this.hashStrategy.hashPosition(sliceIndex, position);
    }

    private boolean positionEqualsCurrentRow(int sliceIndex, int slicePosition, int position, Block[] blocks) {
        return this.hashStrategy.positionEqualsRow(sliceIndex, slicePosition, position, blocks);
    }
}

