/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.net.URI;
import java.util.List;

public class ExchangeOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final ExchangeClient exchangeClient;
    private final List<Type> types;

    public ExchangeOperator(OperatorContext operatorContext, List<Type> types, PlanNodeId sourceId, final ExchangeClient exchangeClient) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
        this.exchangeClient = (ExchangeClient)Preconditions.checkNotNull((Object)exchangeClient, (Object)"exchangeClient is null");
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        operatorContext.setInfoSupplier(new Supplier<Object>(){

            public Object get() {
                return exchangeClient.getStatus();
            }
        });
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)split.getConnectorId().equals("remote"), (Object)"split is not a remote split");
        URI location = ((RemoteSplit)split.getConnectorSplit()).getLocation();
        this.exchangeClient.addLocation(location);
    }

    @Override
    public void noMoreSplits() {
        this.exchangeClient.noMoreLocations();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.exchangeClient.isClosed();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.exchangeClient.isBlocked();
        if (blocked.isDone()) {
            return NOT_BLOCKED;
        }
        return blocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        Page page = this.exchangeClient.pollPage();
        if (page != null) {
            this.operatorContext.recordGeneratedInput(page.getDataSize(), page.getPositionCount());
        }
        return page;
    }

    @Override
    public void close() {
        this.exchangeClient.close();
    }

    public static class ExchangeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final Supplier<ExchangeClient> exchangeClientSupplier;
        private final List<Type> types;
        private boolean closed;

        public ExchangeOperatorFactory(int operatorId, PlanNodeId sourceId, Supplier<ExchangeClient> exchangeClientSupplier, List<Type> types) {
            this.operatorId = operatorId;
            this.sourceId = sourceId;
            this.exchangeClientSupplier = exchangeClientSupplier;
            this.types = types;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, ExchangeOperator.class.getSimpleName());
            return new ExchangeOperator(operatorContext, this.types, this.sourceId, (ExchangeClient)this.exchangeClientSupplier.get());
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

