/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ExchangeClientStatus;
import com.facebook.presto.operator.HttpPageBufferClient;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExchangeClient
implements Closeable {
    private static final Page NO_MORE_PAGES = new Page(0, new Block[0]);
    private final BlockEncodingSerde blockEncodingSerde;
    private final long maxBufferedBytes;
    private final DataSize maxResponseSize;
    private final int concurrentRequestMultiplier;
    private final Duration minErrorDuration;
    private final HttpClient httpClient;
    private final ScheduledExecutorService executor;
    @GuardedBy(value="this")
    private final Set<URI> locations = new HashSet<URI>();
    @GuardedBy(value="this")
    private boolean noMoreLocations;
    private final ConcurrentMap<URI, HttpPageBufferClient> allClients = new ConcurrentHashMap<URI, HttpPageBufferClient>();
    @GuardedBy(value="this")
    private final Deque<HttpPageBufferClient> queuedClients = new LinkedList<HttpPageBufferClient>();
    private final Set<HttpPageBufferClient> completedClients = Sets.newSetFromMap(new ConcurrentHashMap());
    private final LinkedBlockingDeque<Page> pageBuffer = new LinkedBlockingDeque();
    @GuardedBy(value="this")
    private final List<SettableFuture<?>> blockedCallers = new ArrayList();
    @GuardedBy(value="this")
    private long bufferBytes;
    @GuardedBy(value="this")
    private long successfulRequests;
    @GuardedBy(value="this")
    private long averageBytesPerRequest;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<Throwable> failure = new AtomicReference();

    public ExchangeClient(BlockEncodingSerde blockEncodingSerde, DataSize maxBufferedBytes, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration minErrorDuration, HttpClient httpClient, ScheduledExecutorService executor) {
        this.blockEncodingSerde = blockEncodingSerde;
        this.maxBufferedBytes = maxBufferedBytes.toBytes();
        this.maxResponseSize = maxResponseSize;
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.minErrorDuration = minErrorDuration;
        this.httpClient = httpClient;
        this.executor = executor;
    }

    public synchronized ExchangeClientStatus getStatus() {
        int bufferedPages = this.pageBuffer.size();
        if (bufferedPages > 0 && this.pageBuffer.peekLast() == NO_MORE_PAGES) {
            --bufferedPages;
        }
        ImmutableList.Builder exchangeStatus = ImmutableList.builder();
        for (HttpPageBufferClient client : this.allClients.values()) {
            exchangeStatus.add((Object)client.getStatus());
        }
        return new ExchangeClientStatus(this.bufferBytes, this.averageBytesPerRequest, bufferedPages, this.noMoreLocations, (List<PageBufferClientStatus>)exchangeStatus.build());
    }

    public synchronized void addLocation(URI location) {
        Preconditions.checkNotNull((Object)location, (Object)"location is null");
        if (this.locations.contains(location)) {
            return;
        }
        Preconditions.checkState((!this.noMoreLocations ? 1 : 0) != 0, (Object)"No more locations already set");
        this.locations.add(location);
        this.scheduleRequestIfNecessary();
    }

    public synchronized void noMoreLocations() {
        this.noMoreLocations = true;
        this.scheduleRequestIfNecessary();
    }

    @Nullable
    public Page pollPage() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not get next page while holding a lock on this");
        this.throwIfFailed();
        if (this.closed.get()) {
            return null;
        }
        Page page = this.pageBuffer.poll();
        page = this.postProcessPage(page);
        return page;
    }

    @Nullable
    public Page getNextPage(Duration maxWaitTime) throws InterruptedException {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not get next page while holding a lock on this");
        this.throwIfFailed();
        if (this.closed.get()) {
            return null;
        }
        this.scheduleRequestIfNecessary();
        Page page = this.pageBuffer.poll();
        if (page == null && maxWaitTime.toMillis() >= 1L && !this.allClients.isEmpty()) {
            page = this.pageBuffer.poll(maxWaitTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        page = this.postProcessPage(page);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page postProcessPage(Page page) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not get next page while holding a lock on this");
        if (page == NO_MORE_PAGES) {
            this.closed.set(true);
            Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
            this.notifyBlockedCallers();
            page = null;
        }
        if (page != null) {
            ExchangeClient exchangeClient = this;
            synchronized (exchangeClient) {
                this.bufferBytes -= page.getDataSize().toBytes();
            }
            if (!this.closed.get() && this.pageBuffer.peek() == NO_MORE_PAGES) {
                this.closed.set(true);
            }
            this.scheduleRequestIfNecessary();
        }
        return page;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized void close() {
        this.closed.set(true);
        for (HttpPageBufferClient client : this.allClients.values()) {
            ExchangeClient.closeQuietly(client);
        }
        this.pageBuffer.clear();
        this.bufferBytes = 0L;
        if (this.pageBuffer.peekLast() != NO_MORE_PAGES) {
            Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
        }
        this.notifyBlockedCallers();
    }

    public synchronized void scheduleRequestIfNecessary() {
        if (this.isClosed() || this.isFailed()) {
            return;
        }
        if (this.noMoreLocations && this.completedClients.size() == this.locations.size()) {
            if (this.pageBuffer.peekLast() != NO_MORE_PAGES) {
                Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
            }
            if (!this.closed.get() && this.pageBuffer.peek() == NO_MORE_PAGES) {
                this.closed.set(true);
            }
            this.notifyBlockedCallers();
            return;
        }
        for (URI location : this.locations) {
            if (this.allClients.containsKey(location)) continue;
            HttpPageBufferClient client = new HttpPageBufferClient(this.httpClient, this.maxResponseSize, this.minErrorDuration, location, new ExchangeClientCallback(), this.blockEncodingSerde, this.executor);
            this.allClients.put(location, client);
            this.queuedClients.add(client);
        }
        if (this.bufferBytes > this.maxBufferedBytes) {
            return;
        }
        long neededBytes = this.maxBufferedBytes - this.bufferBytes;
        if (neededBytes <= 0L) {
            return;
        }
        int clientCount = (int)(1.0 * (double)neededBytes / (double)this.averageBytesPerRequest * (double)this.concurrentRequestMultiplier);
        clientCount = Math.max(clientCount, 1);
        int pendingClients = this.allClients.size() - this.queuedClients.size() - this.completedClients.size();
        clientCount -= pendingClients;
        for (int i = 0; i < clientCount; ++i) {
            HttpPageBufferClient client = this.queuedClients.poll();
            if (client == null) {
                return;
            }
            client.scheduleRequest();
        }
    }

    public synchronized ListenableFuture<?> isBlocked() {
        if (this.isClosed() || this.isFailed() || this.pageBuffer.peek() != null) {
            return Futures.immediateFuture((Object)true);
        }
        SettableFuture future = SettableFuture.create();
        this.blockedCallers.add(future);
        return future;
    }

    private synchronized void addPage(Page page) {
        if (this.isClosed() || this.isFailed()) {
            return;
        }
        this.pageBuffer.add(page);
        this.notifyBlockedCallers();
        this.bufferBytes += page.getDataSize().toBytes();
        ++this.successfulRequests;
        this.averageBytesPerRequest = (long)(1.0 * (double)this.averageBytesPerRequest * (double)(this.successfulRequests - 1L) / (double)this.successfulRequests + (double)(page.getDataSize().toBytes() / this.successfulRequests));
        this.scheduleRequestIfNecessary();
    }

    private synchronized void notifyBlockedCallers() {
        ImmutableList callers = ImmutableList.copyOf(this.blockedCallers);
        this.blockedCallers.clear();
        for (SettableFuture blockedCaller : callers) {
            blockedCaller.set(null);
        }
    }

    private synchronized void requestComplete(HttpPageBufferClient client) {
        if (!this.queuedClients.contains(client)) {
            this.queuedClients.add(client);
        }
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFinished(HttpPageBufferClient client) {
        Preconditions.checkNotNull((Object)client, (Object)"client is null");
        this.completedClients.add(client);
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFailed(Throwable cause) {
        if (!this.isClosed()) {
            this.failure.compareAndSet(null, cause);
            this.notifyBlockedCallers();
        }
    }

    private boolean isFailed() {
        return this.failure.get() != null;
    }

    private void throwIfFailed() {
        Throwable t = this.failure.get();
        if (t != null) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static void closeQuietly(HttpPageBufferClient client) {
        try {
            client.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private class ExchangeClientCallback
    implements HttpPageBufferClient.ClientCallback {
        private ExchangeClientCallback() {
        }

        @Override
        public void addPage(HttpPageBufferClient client, Page page) {
            Preconditions.checkNotNull((Object)client, (Object)"client is null");
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            ExchangeClient.this.addPage(page);
            ExchangeClient.this.scheduleRequestIfNecessary();
        }

        @Override
        public void requestComplete(HttpPageBufferClient client) {
            Preconditions.checkNotNull((Object)client, (Object)"client is null");
            ExchangeClient.this.requestComplete(client);
        }

        @Override
        public void clientFinished(HttpPageBufferClient client) {
            ExchangeClient.this.clientFinished(client);
        }

        @Override
        public void clientFailed(HttpPageBufferClient client, Throwable cause) {
            Preconditions.checkNotNull((Object)client, (Object)"client is null");
            Preconditions.checkNotNull((Object)cause, (Object)"cause is null");
            ExchangeClient.this.clientFailed(cause);
        }
    }
}

