/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AlignmentOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final List<Iterator<Block>> iterators;
    private final List<BlockPosition> blockPositions;
    private boolean finished;

    public AlignmentOperator(OperatorContext operatorContext, List<Type> types, Iterable<Iterable<Block>> channels) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        ImmutableList.Builder iterators = ImmutableList.builder();
        for (Iterable<Block> iterable : channels) {
            iterators.add(iterable.iterator());
        }
        this.iterators = iterators.build();
        this.blockPositions = new ArrayList<BlockPosition>(this.iterators.size());
        if (this.iterators.get(0).hasNext()) {
            for (Iterator iterator : this.iterators) {
                this.blockPositions.add(new BlockPosition((Block)iterator.next()));
            }
        } else {
            for (Iterator iterator : this.iterators) {
                Preconditions.checkState((!iterator.hasNext() ? 1 : 0) != 0);
            }
            this.finished = true;
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.blockPositions.get(0).getRemainingPositions() <= 0 && !this.iterators.get(0).hasNext()) {
            for (Iterator<Block> iterator : this.iterators) {
                Preconditions.checkState((!iterator.hasNext() ? 1 : 0) != 0);
            }
            this.finished = true;
            return null;
        }
        int length = Integer.MAX_VALUE;
        for (int i = 0; i < this.iterators.size(); ++i) {
            Iterator<Block> iterator = this.iterators.get(i);
            BlockPosition blockPosition = this.blockPositions.get(i);
            if (blockPosition.getRemainingPositions() <= 0) {
                blockPosition = new BlockPosition(iterator.next());
                this.blockPositions.set(i, blockPosition);
            }
            length = Math.min(length, blockPosition.getRemainingPositions());
        }
        Block[] blocks = new Block[this.iterators.size()];
        for (int i = 0; i < this.blockPositions.size(); ++i) {
            blocks[i] = this.blockPositions.get(i).getRegionAndAdvance(length);
        }
        Page page = new Page(blocks);
        this.operatorContext.recordGeneratedInput(page.getDataSize(), page.getPositionCount());
        return page;
    }

    private final class BlockPosition {
        private final Block block;
        private int position;

        private BlockPosition(Block block) {
            this.block = block;
        }

        public Block getRegionAndAdvance(int length) {
            Block region = this.block.getRegion(this.position, length);
            this.position += length;
            return region;
        }

        public int getRemainingPositions() {
            return this.block.getPositionCount() - this.position;
        }
    }
}

