/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Signature {
    private final String name;
    private final List<TypeParameter> typeParameters;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean internal;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="typeParameters") List<TypeParameter> typeParameters, @JsonProperty(value="returnType") String returnType, @JsonProperty(value="argumentTypes") List<String> argumentTypes, @JsonProperty(value="internal") boolean internal) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(typeParameters, (Object)"typeParameters is null");
        Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null");
        this.name = name;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
        this.returnType = TypeSignature.parseTypeSignature((String)((String)Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null")));
        this.argumentTypes = FluentIterable.from(argumentTypes).transform((Function)new Function<String, TypeSignature>(){

            public TypeSignature apply(String input) {
                Preconditions.checkNotNull((Object)input, (Object)"input is null");
                return TypeSignature.parseTypeSignature((String)input);
            }
        }).toList();
        this.internal = internal;
    }

    public Signature(String name, String returnType, List<String> argumentTypes) {
        this(name, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public Signature(String name, String returnType, String ... argumentTypes) {
        this(name, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalOperator(String name, String returnType, List<String> argumentTypes) {
        return Signature.internalFunction(FunctionRegistry.mangleOperatorName(name), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, String returnType, String ... argumentTypes) {
        return Signature.internalFunction(FunctionRegistry.mangleOperatorName(name), returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalFunction(String name, String returnType, String ... argumentTypes) {
        return Signature.internalFunction(name, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalFunction(String name, String returnType, List<String> argumentTypes) {
        return new Signature(name, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, true);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getReturnType() {
        return this.returnType.toString();
    }

    @JsonProperty
    public List<String> getArgumentTypes() {
        return FluentIterable.from(this.argumentTypes).transform((Function)new Function<TypeSignature, String>(){

            public String apply(TypeSignature input) {
                return input.toString();
            }
        }).toList();
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    @JsonProperty
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeParameters, this.returnType, this.argumentTypes, this.internal);
    }

    Signature withAlias(String name) {
        return new Signature(name, this.typeParameters, this.getReturnType(), this.getArgumentTypes(), this.internal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.typeParameters, other.typeParameters) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.internal, other.internal);
    }

    public String toString() {
        return (this.internal ? "%" : "") + this.name + (this.typeParameters.isEmpty() ? "" : "<" + Joiner.on((String)",").join(this.typeParameters) + ">") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }

    public boolean match(Type returnType, List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        HashMap<String, TypeParameter> unboundParameters = new HashMap<String, TypeParameter>();
        for (TypeParameter parameter : this.typeParameters) {
            unboundParameters.put(parameter.getName(), parameter);
        }
        if (!Signature.matchAndBind(boundParameters, unboundParameters, this.returnType, returnType, allowCoercion, typeManager)) {
            return false;
        }
        return Signature.matchArguments(boundParameters, unboundParameters, this.argumentTypes, types, allowCoercion, typeManager);
    }

    public boolean match(List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        HashMap<String, TypeParameter> unboundParameters = new HashMap<String, TypeParameter>();
        for (TypeParameter parameter : this.typeParameters) {
            unboundParameters.put(parameter.getName(), parameter);
        }
        return Signature.matchArguments(boundParameters, unboundParameters, this.argumentTypes, types, allowCoercion, typeManager);
    }

    private static boolean matchArguments(Map<String, Type> boundParameters, Map<String, TypeParameter> unboundParameters, List<TypeSignature> argumentTypes, List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        if (argumentTypes.size() != types.size()) {
            return false;
        }
        for (int i = 0; i < types.size(); ++i) {
            Type type;
            TypeSignature typeSignature = argumentTypes.get(Math.min(i, argumentTypes.size() - 1));
            if (Signature.matchAndBind(boundParameters, unboundParameters, typeSignature, type = types.get(i), allowCoercion, typeManager)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAndBind(Map<String, Type> boundParameters, Map<String, TypeParameter> unboundParameters, TypeSignature signature, Type type, boolean allowCoercion, TypeManager typeManager) {
        if (boundParameters.containsKey(signature.getBase())) {
            Preconditions.checkArgument((boolean)signature.getParameters().isEmpty(), (Object)"Unexpected parameteric type");
            if (allowCoercion) {
                return FunctionRegistry.canCoerce(type, boundParameters.get(signature.getBase()));
            }
            return type.equals(boundParameters.get(signature.getBase()));
        }
        if (unboundParameters.containsKey(signature.getBase())) {
            TypeParameter typeParameter = unboundParameters.get(signature.getBase());
            if (!typeParameter.canBind(type)) {
                return false;
            }
            unboundParameters.remove(signature.getBase());
            boundParameters.put(signature.getBase(), type);
            return true;
        }
        if (allowCoercion) {
            return FunctionRegistry.canCoerce(type, typeManager.getType(signature.getBase()));
        }
        return type.equals(typeManager.getType(signature.getBase()));
    }

    public static TypeParameter typeParameter(String name) {
        return new TypeParameter(name, false);
    }

    public static TypeParameter typeParameter(String name, boolean comparableRequired) {
        return new TypeParameter(name, comparableRequired);
    }

    public static final class TypeParameter {
        private final String name;
        private final boolean comparableRequired;

        @JsonCreator
        public TypeParameter(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
            this.comparableRequired = comparableRequired;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public boolean isComparableRequired() {
            return this.comparableRequired;
        }

        public boolean canBind(Type type) {
            return !this.comparableRequired || type.isComparable();
        }

        public String toString() {
            return this.comparableRequired ? this.name + ":comparable" : this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.comparableRequired, other.comparableRequired);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.comparableRequired);
        }
    }
}

