/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public abstract class ParametricOperator
implements ParametricFunction {
    private final OperatorType operatorType;
    private final List<Signature.TypeParameter> typeParameters;
    private final String returnType;
    private final List<String> argumentTypes;

    protected ParametricOperator(OperatorType operatorType, List<Signature.TypeParameter> typeParameters, String returnType, List<String> argumentTypes) {
        this.typeParameters = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(typeParameters, (Object)"typeParameters is null")));
        this.returnType = (String)Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null")));
        this.operatorType = (OperatorType)((Object)Preconditions.checkNotNull((Object)((Object)operatorType), (Object)"operatorType is null"));
    }

    @Override
    public Signature getSignature() {
        return new Signature(FunctionRegistry.mangleOperatorName(this.operatorType), this.typeParameters, this.returnType, this.argumentTypes, true);
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isApproximate() {
        return false;
    }

    @Override
    public boolean isWindow() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isUnbound() {
        return true;
    }
}

