/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Provider;

public class MetadataManager
implements Metadata {
    private final Set<String> globalConnectors = Sets.newConcurrentHashSet();
    private final ConcurrentMap<String, ConnectorMetadataEntry> informationSchemasByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> connectorsByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadata> connectorsById = new ConcurrentHashMap<String, ConnectorMetadata>();
    private final FunctionRegistry functions;
    private final TypeManager typeManager;
    private final JsonCodec<ViewDefinition> viewCodec;

    public MetadataManager() {
        this(new FeaturesConfig(), new TypeRegistry());
    }

    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager) {
        this(featuresConfig, typeManager, MetadataManager.createTestingViewCodec());
    }

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, JsonCodec<ViewDefinition> viewCodec) {
        this.functions = new FunctionRegistry(typeManager, featuresConfig.isExperimentalSyntaxEnabled());
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"types is null");
        this.viewCodec = (JsonCodec)Preconditions.checkNotNull(viewCodec, (Object)"viewCodec is null");
    }

    public synchronized void addConnectorMetadata(String connectorId, String catalogName, ConnectorMetadata connectorMetadata) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull((Object)connectorMetadata, (Object)"connectorMetadata is null");
        Preconditions.checkArgument((!this.connectorsByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        Preconditions.checkArgument((!this.connectorsById.containsKey(connectorId) ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object[])new Object[]{connectorId});
        ConnectorMetadataEntry entry = new ConnectorMetadataEntry(connectorId, connectorMetadata);
        this.connectorsById.put(connectorId, connectorMetadata);
        this.connectorsByCatalog.put(catalogName, entry);
    }

    public synchronized void addInformationSchemaMetadata(String connectorId, String catalogName, InformationSchemaMetadata metadata) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull((Object)((Object)metadata), (Object)"metadata is null");
        Preconditions.checkArgument((!this.connectorsById.containsKey(connectorId) ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object[])new Object[]{connectorId});
        Preconditions.checkArgument((!this.informationSchemasByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Information schema for catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        this.connectorsById.put(connectorId, (ConnectorMetadata)metadata);
        this.informationSchemasByCatalog.put(catalogName, new ConnectorMetadataEntry(connectorId, (ConnectorMetadata)metadata));
    }

    public synchronized void addGlobalSchemaMetadata(String connectorId, ConnectorMetadata connectorMetadata) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)connectorMetadata, (Object)"connectorMetadata is null");
        Preconditions.checkArgument((!this.globalConnectors.contains(connectorId) ? 1 : 0) != 0, (String)"Global connector '%s' is already registered", (Object[])new Object[]{connectorId});
        Preconditions.checkArgument((!this.connectorsById.containsKey(connectorId) ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object[])new Object[]{connectorId});
        this.connectorsById.put(connectorId, connectorMetadata);
        this.globalConnectors.add(connectorId);
    }

    @Override
    public Type getType(String typeName) {
        return this.typeManager.getType(typeName);
    }

    @Override
    public FunctionInfo resolveFunction(QualifiedName name, List<String> parameterTypes, boolean approximate) {
        return this.functions.resolveFunction(name, parameterTypes, approximate);
    }

    @Override
    public FunctionInfo getExactFunction(Signature handle) {
        return this.functions.getExactFunction(handle);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<ParametricFunction> listFunctions() {
        return this.functions.list();
    }

    @Override
    public void addFunctions(List<? extends ParametricFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public FunctionInfo resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.functions.resolveOperator(operatorType, argumentTypes);
    }

    @Override
    public List<String> listSchemaNames(ConnectorSession session, String catalogName) {
        MetadataUtil.checkCatalogName(catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(catalogName)) {
            schemaNames.addAll((Iterable)entry.getMetadata().listSchemaNames(session));
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(ConnectorSession session, QualifiedTableName table) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        SchemaTableName tableName = table.asSchemaTableName();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(table.getCatalogName())) {
            ConnectorTableHandle tableHandle = entry.getMetadata().getTableHandle(session, tableName);
            if (tableHandle == null) continue;
            return Optional.of((Object)new TableHandle(entry.getConnectorId(), tableHandle));
        }
        return Optional.absent();
    }

    @Override
    public TableMetadata getTableMetadata(TableHandle tableHandle) {
        ConnectorTableMetadata tableMetadata = this.lookupConnectorFor(tableHandle).getTableMetadata(tableHandle.getConnectorHandle());
        return new TableMetadata(tableHandle.getConnectorId(), tableMetadata);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        Map columns = this.lookupConnectorFor(tableHandle).getColumnHandles(tableHandle.getConnectorHandle());
        return Maps.transformValues((Map)columns, ColumnHandle.fromConnectorHandle(tableHandle.getConnectorId()));
    }

    @Override
    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        return this.lookupConnectorFor(tableHandle).getColumnMetadata(tableHandle.getConnectorHandle(), columnHandle.getConnectorHandle());
    }

    @Override
    public List<QualifiedTableName> listTables(ConnectorSession session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        String schemaNameOrNull = (String)prefix.getSchemaName().orNull();
        LinkedHashSet<QualifiedTableName> tables = new LinkedHashSet<QualifiedTableName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            for (QualifiedTableName tableName : Iterables.transform((Iterable)entry.getMetadata().listTables(session, schemaNameOrNull), QualifiedTableName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                tables.add(tableName);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Optional<ColumnHandle> getSampleWeightColumnHandle(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        ConnectorColumnHandle handle = this.lookupConnectorFor(tableHandle).getSampleWeightColumnHandle(tableHandle.getConnectorHandle());
        if (handle == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new ColumnHandle(tableHandle.getConnectorId(), handle));
    }

    @Override
    public boolean canCreateSampledTables(ConnectorSession session, String catalogName) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        return connectorMetadata.getMetadata().canCreateSampledTables(session);
    }

    @Override
    public Map<QualifiedTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        HashMap tableColumns = new HashMap();
        for (ConnectorMetadataEntry connectorMetadata : this.allConnectorsFor(prefix.getCatalogName())) {
            QualifiedTableName tableName;
            ConnectorMetadata metadata = connectorMetadata.getMetadata();
            for (Map.Entry entry : metadata.listTableColumns(session, tablePrefix).entrySet()) {
                tableName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                tableColumns.put(tableName, entry.getValue());
            }
            for (Map.Entry entry : metadata.getViews(session, tablePrefix).entrySet()) {
                tableName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                int ordinalPosition = 0;
                ImmutableList.Builder columns = ImmutableList.builder();
                for (ViewDefinition.ViewColumn column : this.deserializeView((String)entry.getValue()).getColumns()) {
                    columns.add((Object)new ColumnMetadata(column.getName(), column.getType(), ordinalPosition, false));
                    ++ordinalPosition;
                }
                tableColumns.put(tableName, columns.build());
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public TableHandle createTable(ConnectorSession session, String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorTableHandle handle = connectorMetadata.getMetadata().createTable(session, tableMetadata.getMetadata());
        return new TableHandle(connectorMetadata.getConnectorId(), handle);
    }

    @Override
    public void renameTable(TableHandle tableHandle, QualifiedTableName newTableName) {
        String catalogName = newTableName.getCatalogName();
        ConnectorMetadataEntry target = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        if (target == null) {
            throw new PrestoException(StandardErrorCode.NOT_FOUND.toErrorCode(), String.format("Target catalog '%s' does not exist", catalogName));
        }
        if (!tableHandle.getConnectorId().equals(target.getConnectorId())) {
            throw new PrestoException(StandardErrorCode.SYNTAX_ERROR.toErrorCode(), "Cannot rename tables across catalogs");
        }
        this.lookupConnectorFor(tableHandle).renameTable(tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void dropTable(TableHandle tableHandle) {
        this.lookupConnectorFor(tableHandle).dropTable(tableHandle.getConnectorHandle());
    }

    @Override
    public OutputTableHandle beginCreateTable(ConnectorSession session, String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorOutputTableHandle handle = connectorMetadata.getMetadata().beginCreateTable(session, tableMetadata.getMetadata());
        return new OutputTableHandle(connectorMetadata.getConnectorId(), handle);
    }

    @Override
    public void commitCreateTable(OutputTableHandle tableHandle, Collection<String> fragments) {
        this.lookupConnectorFor(tableHandle).commitCreateTable(tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public InsertTableHandle beginInsert(ConnectorSession session, TableHandle tableHandle) {
        ConnectorInsertTableHandle handle = this.lookupConnectorFor(tableHandle).beginInsert(session, tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), handle);
    }

    @Override
    public void commitInsert(InsertTableHandle tableHandle, Collection<String> fragments) {
        this.lookupConnectorFor(tableHandle).commitInsert(tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Map<String, String> getCatalogNames() {
        ImmutableMap.Builder catalogsMap = ImmutableMap.builder();
        for (Map.Entry entry : this.connectorsByCatalog.entrySet()) {
            catalogsMap.put(entry.getKey(), (Object)((ConnectorMetadataEntry)entry.getValue()).getConnectorId());
        }
        return catalogsMap.build();
    }

    @Override
    public List<QualifiedTableName> listViews(ConnectorSession session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        String schemaNameOrNull = (String)prefix.getSchemaName().orNull();
        LinkedHashSet<QualifiedTableName> views = new LinkedHashSet<QualifiedTableName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            for (QualifiedTableName tableName : Iterables.transform((Iterable)entry.getMetadata().listViews(session, schemaNameOrNull), QualifiedTableName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                views.add(tableName);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedTableName, ViewDefinition> getViews(ConnectorSession session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        LinkedHashMap<QualifiedTableName, ViewDefinition> views = new LinkedHashMap<QualifiedTableName, ViewDefinition>();
        for (ConnectorMetadataEntry metadata : this.allConnectorsFor(prefix.getCatalogName())) {
            for (Map.Entry entry : metadata.getMetadata().getViews(session, tablePrefix).entrySet()) {
                QualifiedTableName viewName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                views.put(viewName, this.deserializeView((String)entry.getValue()));
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Optional<ViewDefinition> getView(ConnectorSession session, QualifiedTableName viewName) {
        SchemaTablePrefix prefix = viewName.asSchemaTableName().toSchemaTablePrefix();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(viewName.getCatalogName())) {
            Map views = entry.getMetadata().getViews(session, prefix);
            String view = (String)views.get(viewName.asSchemaTableName());
            if (view == null) continue;
            return Optional.of((Object)this.deserializeView(view));
        }
        return Optional.absent();
    }

    @Override
    public void createView(ConnectorSession session, QualifiedTableName viewName, String viewData, boolean replace) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        connectorMetadata.getMetadata().createView(session, viewName.asSchemaTableName(), viewData, replace);
    }

    @Override
    public void dropView(ConnectorSession session, QualifiedTableName viewName) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        connectorMetadata.getMetadata().dropView(session, viewName.asSchemaTableName());
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functions;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    private ViewDefinition deserializeView(String data) {
        try {
            return (ViewDefinition)this.viewCodec.fromJson(data);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException(StandardErrorCode.INVALID_VIEW.toErrorCode(), "Invalid view JSON: " + data, (Throwable)e);
        }
    }

    private List<ConnectorMetadataEntry> allConnectorsFor(String catalogName) {
        ConnectorMetadataEntry connector;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String connectorId : this.globalConnectors) {
            builder.add((Object)new ConnectorMetadataEntry(connectorId, (ConnectorMetadata)this.connectorsById.get(connectorId)));
        }
        ConnectorMetadataEntry entry = (ConnectorMetadataEntry)this.informationSchemasByCatalog.get(catalogName);
        if (entry != null) {
            builder.add((Object)entry);
        }
        if ((connector = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName)) != null) {
            builder.add((Object)connector);
        }
        return builder.build();
    }

    private ConnectorMetadata lookupConnectorFor(TableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadata lookupConnectorFor(OutputTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadata lookupConnectorFor(InsertTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadata getConnectorMetadata(String connectorId) {
        ConnectorMetadata result = (ConnectorMetadata)this.connectorsById.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No connector for connector ID: %s", (Object[])new Object[]{connectorId});
        return result;
    }

    private static JsonCodec<ViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(new TypeRegistry()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ViewDefinition.class);
    }

    private static class ConnectorMetadataEntry {
        private final String connectorId;
        private final ConnectorMetadata metadata;

        private ConnectorMetadataEntry(String connectorId, ConnectorMetadata metadata) {
            this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
            this.metadata = (ConnectorMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        }

        private String getConnectorId() {
            return this.connectorId;
        }

        private ConnectorMetadata getMetadata() {
            return this.metadata;
        }
    }
}

