/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public interface Metadata {
    public Type getType(String var1);

    public FunctionInfo resolveFunction(QualifiedName var1, List<String> var2, boolean var3);

    @NotNull
    public FunctionInfo getExactFunction(Signature var1);

    public boolean isAggregationFunction(QualifiedName var1);

    @NotNull
    public List<ParametricFunction> listFunctions();

    public void addFunctions(List<? extends ParametricFunction> var1);

    public FunctionInfo resolveOperator(OperatorType var1, List<? extends Type> var2) throws OperatorNotFoundException;

    @NotNull
    public List<String> listSchemaNames(ConnectorSession var1, String var2);

    @NotNull
    public Optional<TableHandle> getTableHandle(ConnectorSession var1, QualifiedTableName var2);

    @NotNull
    public TableMetadata getTableMetadata(TableHandle var1);

    @NotNull
    public List<QualifiedTableName> listTables(ConnectorSession var1, QualifiedTablePrefix var2);

    @NotNull
    public Optional<ColumnHandle> getSampleWeightColumnHandle(TableHandle var1);

    public boolean canCreateSampledTables(ConnectorSession var1, String var2);

    @NotNull
    public Map<String, ColumnHandle> getColumnHandles(TableHandle var1);

    @NotNull
    public ColumnMetadata getColumnMetadata(TableHandle var1, ColumnHandle var2);

    @NotNull
    public Map<QualifiedTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession var1, QualifiedTablePrefix var2);

    @NotNull
    public TableHandle createTable(ConnectorSession var1, String var2, TableMetadata var3);

    public void renameTable(TableHandle var1, QualifiedTableName var2);

    public void dropTable(TableHandle var1);

    public OutputTableHandle beginCreateTable(ConnectorSession var1, String var2, TableMetadata var3);

    public void commitCreateTable(OutputTableHandle var1, Collection<String> var2);

    public InsertTableHandle beginInsert(ConnectorSession var1, TableHandle var2);

    public void commitInsert(InsertTableHandle var1, Collection<String> var2);

    @NotNull
    public Map<String, String> getCatalogNames();

    @NotNull
    public List<QualifiedTableName> listViews(ConnectorSession var1, QualifiedTablePrefix var2);

    @NotNull
    public Map<QualifiedTableName, ViewDefinition> getViews(ConnectorSession var1, QualifiedTablePrefix var2);

    @NotNull
    public Optional<ViewDefinition> getView(ConnectorSession var1, QualifiedTableName var2);

    public void createView(ConnectorSession var1, QualifiedTableName var2, String var3, boolean var4);

    public void dropView(ConnectorSession var1, QualifiedTableName var2);

    public FunctionRegistry getFunctionRegistry();

    public TypeManager getTypeManager();
}

