/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalTable {
    private final Map<String, Type> types;
    private final Map<String, Iterable<Block>> columns;

    public InternalTable(Map<String, Type> types, Map<String, Iterable<Block>> columns) {
        this.types = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.columns = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(columns, (Object)"columns is null")));
    }

    public Set<String> getColumnNames() {
        return this.columns.keySet();
    }

    public Type getType(String columnName) {
        return this.types.get(columnName);
    }

    public Iterable<Block> getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public List<Iterable<Block>> getColumns(List<String> columnNames) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (String columnName : columnNames) {
            columns.add(this.getColumn(columnName));
        }
        return columns.build();
    }

    public static Builder builder(ColumnMetadata ... columns) {
        return InternalTable.builder((List<ColumnMetadata>)ImmutableList.copyOf((Object[])columns));
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnMetadata column : columns) {
            names.add((Object)column.getName());
            types.add((Object)column.getType());
        }
        return new Builder((List<Type>)types.build(), (List<String>)names.build());
    }

    public static class Builder {
        private final List<Type> types;
        private final List<String> columnNames;
        private final List<List<Block>> columns;
        private PageBuilder pageBuilder;

        public Builder(List<Type> types, List<String> columnNames) {
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.columnNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnNames, (Object)"columnNames is null")));
            Preconditions.checkArgument((columnNames.size() == types.size() ? 1 : 0) != 0, (String)"Column name count does not match type count: columnNames=%s, types=%s", (Object[])new Object[]{columnNames, types.size()});
            this.columns = new ArrayList<List<Block>>();
            for (int i = 0; i < types.size(); ++i) {
                this.columns.add(new ArrayList());
            }
            this.pageBuilder = new PageBuilder(types);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Builder add(Object ... values) {
            for (int i = 0; i < this.types.size(); ++i) {
                BlockUtils.appendObject(this.types.get(i), this.pageBuilder.getBlockBuilder(i), values[i]);
            }
            if (this.pageBuilder.isFull()) {
                this.flushPage();
                this.pageBuilder.reset();
            }
            return this;
        }

        public InternalTable build() {
            this.flushPage();
            ImmutableMap.Builder columnTypes = ImmutableMap.builder();
            ImmutableMap.Builder data = ImmutableMap.builder();
            for (int i = 0; i < this.columnNames.size(); ++i) {
                columnTypes.put((Object)this.columnNames.get(i), (Object)this.types.get(i));
                data.put((Object)this.columnNames.get(i), this.columns.get(i));
            }
            return new InternalTable((Map<String, Type>)columnTypes.build(), (Map<String, Iterable<Block>>)data.build());
        }

        private void flushPage() {
            if (!this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                for (int i = 0; i < this.types.size(); ++i) {
                    this.columns.get(i).add(page.getBlock(i));
                }
            }
        }
    }
}

