/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.ParametricFunctionUtils;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.ApproximateAverageAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountAggregation;
import com.facebook.presto.operator.aggregation.ApproximateCountColumnAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountDistinctAggregations;
import com.facebook.presto.operator.aggregation.ApproximateDoublePercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateSetAggregation;
import com.facebook.presto.operator.aggregation.ApproximateSumAggregations;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.BooleanMaxAggregation;
import com.facebook.presto.operator.aggregation.BooleanMinAggregation;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.CountColumnAggregations;
import com.facebook.presto.operator.aggregation.CountIfAggregation;
import com.facebook.presto.operator.aggregation.DoubleMaxAggregation;
import com.facebook.presto.operator.aggregation.DoubleMinAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.LongMaxAggregation;
import com.facebook.presto.operator.aggregation.LongMinAggregation;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.MaxByAggregations;
import com.facebook.presto.operator.aggregation.MergeHyperLogLogAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMaxAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMinAggregation;
import com.facebook.presto.operator.aggregation.VarianceAggregation;
import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.HyperLogLogFunctions;
import com.facebook.presto.operator.scalar.IdentityCastParametricFunction;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.RegexpFunctions;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.operator.scalar.UrlFunctions;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.operator.window.CumulativeDistributionFunction;
import com.facebook.presto.operator.window.DenseRankFunction;
import com.facebook.presto.operator.window.FirstValueFunction;
import com.facebook.presto.operator.window.LagFunction;
import com.facebook.presto.operator.window.LastValueFunction;
import com.facebook.presto.operator.window.LeadFunction;
import com.facebook.presto.operator.window.NthValueFunction;
import com.facebook.presto.operator.window.PercentRankFunction;
import com.facebook.presto.operator.window.RankFunction;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.BooleanOperators;
import com.facebook.presto.type.DateOperators;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.HyperLogLogOperators;
import com.facebook.presto.type.IntervalDayTimeOperators;
import com.facebook.presto.type.IntervalYearMonthOperators;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.RegexpType;
import com.facebook.presto.type.TimeOperators;
import com.facebook.presto.type.TimeWithTimeZoneOperators;
import com.facebook.presto.type.TimestampOperators;
import com.facebook.presto.type.TimestampWithTimeZoneOperators;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.type.VarbinaryOperators;
import com.facebook.presto.type.VarcharOperators;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private static final String MAGIC_LITERAL_FUNCTION_PREFIX = "$literal$";
    private static final String OPERATOR_PREFIX = "$operator$";
    private static final Set<Class<?>> SUPPORTED_LITERAL_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);
    private final TypeManager typeManager;
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry(TypeManager typeManager, boolean experimentalSyntaxEnabled) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        FunctionListBuilder builder = new FunctionListBuilder(typeManager).window("row_number", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), RowNumberFunction.class).window("rank", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), RankFunction.class).window("dense_rank", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), DenseRankFunction.class).window("percent_rank", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of(), PercentRankFunction.class).window("cume_dist", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of(), CumulativeDistributionFunction.class).window("first_value", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), FirstValueFunction.BigintFirstValueFunction.class).window("first_value", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), FirstValueFunction.DoubleFirstValueFunction.class).window("first_value", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), FirstValueFunction.BooleanFirstValueFunction.class).window("first_value", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), FirstValueFunction.VarcharFirstValueFunction.class).window("last_value", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), LastValueFunction.BigintLastValueFunction.class).window("last_value", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), LastValueFunction.DoubleLastValueFunction.class).window("last_value", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), LastValueFunction.BooleanLastValueFunction.class).window("last_value", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), LastValueFunction.VarcharLastValueFunction.class).window("nth_value", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), NthValueFunction.BigintNthValueFunction.class).window("nth_value", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), NthValueFunction.DoubleNthValueFunction.class).window("nth_value", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT), NthValueFunction.BooleanNthValueFunction.class).window("nth_value", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), NthValueFunction.VarcharNthValueFunction.class).window("lag", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), LagFunction.BigintLagFunction.class).window("lag", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), LagFunction.BigintLagFunction.class).window("lag", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), LagFunction.BigintLagFunction.class).window("lag", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), LagFunction.DoubleLagFunction.class).window("lag", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), LagFunction.DoubleLagFunction.class).window("lag", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), LagFunction.DoubleLagFunction.class).window("lag", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), LagFunction.BooleanLagFunction.class).window("lag", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT), LagFunction.BooleanLagFunction.class).window("lag", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN), LagFunction.BooleanLagFunction.class).window("lag", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), LagFunction.VarcharLagFunction.class).window("lag", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), LagFunction.VarcharLagFunction.class).window("lag", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), LagFunction.VarcharLagFunction.class).window("lead", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), LeadFunction.BigintLeadFunction.class).window("lead", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), LeadFunction.BigintLeadFunction.class).window("lead", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), LeadFunction.BigintLeadFunction.class).window("lead", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), LeadFunction.DoubleLeadFunction.class).window("lead", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), LeadFunction.DoubleLeadFunction.class).window("lead", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), LeadFunction.DoubleLeadFunction.class).window("lead", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), LeadFunction.BooleanLeadFunction.class).window("lead", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT), LeadFunction.BooleanLeadFunction.class).window("lead", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN), LeadFunction.BooleanLeadFunction.class).window("lead", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), LeadFunction.VarcharLeadFunction.class).window("lead", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), LeadFunction.VarcharLeadFunction.class).window("lead", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), LeadFunction.VarcharLeadFunction.class).aggregate(CountAggregation.COUNT).aggregate(VarianceAggregation.class).aggregate(ApproximateLongPercentileAggregations.class).aggregate(ApproximateDoublePercentileAggregations.class).aggregate(CountIfAggregation.class).aggregate(CountColumnAggregations.class).aggregate(BooleanMinAggregation.class).aggregate(BooleanMaxAggregation.class).aggregate(DoubleMinAggregation.class).aggregate(DoubleMaxAggregation.class).aggregate(LongMinAggregation.class).aggregate(LongMaxAggregation.class).aggregate(VarBinaryMinAggregation.class).aggregate(VarBinaryMaxAggregation.class).aggregate(DoubleSumAggregation.class).aggregate(LongSumAggregation.class).aggregate(AverageAggregations.class).aggregate(ApproximateCountDistinctAggregations.class).aggregate(MergeHyperLogLogAggregation.class).aggregate(ApproximateSetAggregation.class).aggregate(MaxByAggregations.getAggregations(typeManager)).scalar(StringFunctions.class).scalar(VarbinaryFunctions.class).scalar(RegexpFunctions.class).scalar(UrlFunctions.class).scalar(MathFunctions.class).scalar(DateTimeFunctions.class).scalar(JsonFunctions.class).scalar(ColorFunctions.class).scalar(HyperLogLogFunctions.class).scalar(BooleanOperators.class).scalar(BigintOperators.class).scalar(DoubleOperators.class).scalar(VarcharOperators.class).scalar(VarbinaryOperators.class).scalar(DateOperators.class).scalar(TimeOperators.class).scalar(TimestampOperators.class).scalar(IntervalDayTimeOperators.class).scalar(IntervalYearMonthOperators.class).scalar(TimeWithTimeZoneOperators.class).scalar(TimestampWithTimeZoneOperators.class).scalar(DateTimeOperators.class).scalar(HyperLogLogOperators.class).scalar(LikeFunctions.class).parametricScalar(IdentityCastParametricFunction.IDENTITY_CAST);
        if (experimentalSyntaxEnabled) {
            builder.aggregate(ApproximateAverageAggregations.class).aggregate(ApproximateSumAggregations.class).aggregate(ApproximateCountAggregation.APPROXIMATE_COUNT_AGGREGATION).aggregate(ApproximateCountColumnAggregations.class);
        }
        this.addFunctions(builder.getFunctions());
    }

    public final synchronized void addFunctions(List<? extends ParametricFunction> functions) {
        for (ParametricFunction parametricFunction : functions) {
            for (ParametricFunction existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!parametricFunction.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object[])new Object[]{parametricFunction.getSignature()});
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<ParametricFunction> list() {
        return FluentIterable.from(this.functions.list()).filter(Predicates.not(ParametricFunctionUtils.isHiddenPredicate())).toList();
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return Iterables.any(this.functions.get(name), ParametricFunctionUtils.isAggregationPredicate());
    }

    public FunctionInfo resolveFunction(QualifiedName name, List<String> parameterTypes, final boolean approximate) {
        List<ParametricFunction> candidates = IterableTransformer.on(this.functions.get(name)).select(new Predicate<ParametricFunction>(){

            public boolean apply(ParametricFunction input) {
                return input.isScalar() || input.isApproximate() == approximate;
            }
        }).list();
        List<Type> resolvedTypes = FunctionRegistry.resolveTypes(parameterTypes, this.typeManager);
        FunctionInfo match = null;
        for (ParametricFunction function : candidates) {
            if (!function.getSignature().match(resolvedTypes, false, this.typeManager)) continue;
            Preconditions.checkArgument((match == null ? 1 : 0) != 0, (String)"Ambiguous call to %s with parameters %s", (Object[])new Object[]{name, parameterTypes});
            match = function.specialize(resolvedTypes);
        }
        if (match != null) {
            return match;
        }
        for (ParametricFunction function : candidates) {
            if (!function.getSignature().match(resolvedTypes, true, this.typeManager)) continue;
            return function.specialize(resolvedTypes);
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (ParametricFunction function : candidates) {
            expectedParameters.add(String.format("%s(%s)", name, Joiner.on((String)", ").join(function.getSignature().getArgumentTypes())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String message = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        if (name.getSuffix().startsWith(MAGIC_LITERAL_FUNCTION_PREFIX)) {
            String typeName = name.getSuffix().substring(MAGIC_LITERAL_FUNCTION_PREFIX.length());
            Type type = this.typeManager.getType(typeName);
            Preconditions.checkNotNull((Object)type, (String)"Type %s not registered", (Object[])new Object[]{typeName});
            Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", (Object[])new Object[]{parameterTypes});
            Type parameterType = this.typeManager.getType(parameterTypes.get(0));
            Preconditions.checkNotNull((Object)parameterType, (String)"Type %s not foudn", (Object[])new Object[]{parameterTypes.get(0)});
            Preconditions.checkArgument((parameterType.getJavaType() == type.getJavaType() ? 1 : 0) != 0, (String)"Expected type %s to use Java type %s, but Java type is %s", (Object[])new Object[]{type, parameterType.getJavaType(), type.getJavaType()});
            MethodHandle identity = MethodHandles.identity(parameterType.getJavaType());
            return new FunctionInfo(FunctionRegistry.getMagicLiteralFunctionSignature(type), null, true, identity, true, false, (List<Boolean>)ImmutableList.of((Object)false));
        }
        throw new PrestoException(StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode(), message);
    }

    public FunctionInfo getExactFunction(Signature signature) {
        Collection<ParametricFunction> candidates = this.functions.get(QualifiedName.of((String)signature.getName(), (String[])new String[0]));
        for (ParametricFunction operator : candidates) {
            Type returnType = this.typeManager.getType(signature.getReturnType());
            List<Type> argumentTypes = FunctionRegistry.resolveTypes(signature.getArgumentTypes(), this.typeManager);
            if (!operator.getSignature().match(returnType, argumentTypes, false, this.typeManager)) continue;
            return operator.specialize(returnType, argumentTypes);
        }
        return null;
    }

    @VisibleForTesting
    public List<ParametricFunction> listOperators() {
        ImmutableSet operatorNames = FluentIterable.from(Arrays.asList(OperatorType.values())).transform((Function)new Function<OperatorType, String>(){

            public String apply(OperatorType input) {
                return FunctionRegistry.mangleOperatorName(input);
            }
        }).toSet();
        return FluentIterable.from((Iterable)this.functions.functions.values()).filter((Predicate)new Predicate<ParametricFunction>((Set)operatorNames){
            final /* synthetic */ Set val$operatorNames;
            {
                this.val$operatorNames = set;
            }

            public boolean apply(ParametricFunction input) {
                return this.val$operatorNames.contains(input.getSignature().getName());
            }
        }).toList();
    }

    public FunctionInfo resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return this.resolveFunction(QualifiedName.of((String)FunctionRegistry.mangleOperatorName(operatorType), (String[])new String[0]), Lists.transform(argumentTypes, TypeUtils.nameGetter()), false);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, argumentTypes);
            }
            throw e;
        }
    }

    public static List<Type> resolveTypes(List<String> typeNames, final TypeManager typeManager) {
        return FluentIterable.from(typeNames).transform((Function)new Function<String, Type>(){

            public Type apply(String type) {
                return (Type)Preconditions.checkNotNull((Object)typeManager.getType(type), (String)"Type '%s' not found", (Object[])new Object[]{type});
            }
        }).toList();
    }

    public FunctionInfo getCoercion(Type fromType, Type toType) {
        return this.getExactOperator(OperatorType.CAST, (List<? extends Type>)ImmutableList.of((Object)fromType), toType);
    }

    private FunctionInfo getExactOperator(OperatorType operatorType, List<? extends Type> argumentTypes, Type returnType) throws OperatorNotFoundException {
        FunctionInfo functionInfo = this.getExactFunction(Signature.internalOperator(operatorType.name(), returnType.getName(), Lists.transform(argumentTypes, TypeUtils.nameGetter())));
        if (functionInfo == null) {
            throw new OperatorNotFoundException(operatorType, argumentTypes, returnType);
        }
        return functionInfo;
    }

    public static boolean canCoerce(List<? extends Type> actualTypes, List<Type> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < expectedTypes.size(); ++i) {
            Type expectedType = expectedTypes.get(i);
            Type actualType = actualTypes.get(i);
            if (FunctionRegistry.canCoerce(actualType, expectedType)) continue;
            return false;
        }
        return true;
    }

    public static boolean canCoerce(Type actualType, Type expectedType) {
        if (expectedType.equals(actualType)) {
            return true;
        }
        if (actualType.equals((Object)UnknownType.UNKNOWN)) {
            return true;
        }
        if (actualType.equals(BigintType.BIGINT) && expectedType.equals(DoubleType.DOUBLE)) {
            return true;
        }
        if (actualType.equals(DateType.DATE) && expectedType.equals(TimestampType.TIMESTAMP)) {
            return true;
        }
        if (actualType.equals(DateType.DATE) && expectedType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(TimeType.TIME) && expectedType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(TimestampType.TIMESTAMP) && expectedType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(VarcharType.VARCHAR) && expectedType.equals((Object)RegexpType.REGEXP)) {
            return true;
        }
        if (actualType.equals(VarcharType.VARCHAR) && expectedType.equals((Object)LikePatternType.LIKE_PATTERN)) {
            return true;
        }
        return actualType.equals(VarcharType.VARCHAR) && expectedType.equals((Object)JsonPathType.JSON_PATH);
    }

    public static Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        if (firstType.equals((Object)UnknownType.UNKNOWN)) {
            return Optional.of((Object)secondType);
        }
        if (secondType.equals((Object)UnknownType.UNKNOWN)) {
            return Optional.of((Object)firstType);
        }
        if (firstType.equals(secondType)) {
            return Optional.of((Object)firstType);
        }
        if ((firstType.equals(BigintType.BIGINT) || firstType.equals(DoubleType.DOUBLE)) && (secondType.equals(BigintType.BIGINT) || secondType.equals(DoubleType.DOUBLE))) {
            return Optional.of((Object)DoubleType.DOUBLE);
        }
        if ((firstType.equals(TimeType.TIME) || firstType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) && (secondType.equals(TimeType.TIME) || secondType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE))) {
            return Optional.of((Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        }
        if ((firstType.equals(TimestampType.TIMESTAMP) || firstType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) && (secondType.equals(TimestampType.TIMESTAMP) || secondType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
            return Optional.of((Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        }
        return Optional.absent();
    }

    public static Type type(Class<?> clazz) {
        if ((clazz = Primitives.unwrap(clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (clazz == Slice.class) {
            return VarcharType.VARCHAR;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }

    public static Signature getMagicLiteralFunctionSignature(Type type) {
        return new Signature(MAGIC_LITERAL_FUNCTION_PREFIX + type.getName(), type.getName(), Lists.transform((List)ImmutableList.of((Object)FunctionRegistry.type(type.getJavaType())), TypeUtils.nameGetter()));
    }

    public static boolean isSupportedLiteralType(Type type) {
        return SUPPORTED_LITERAL_TYPES.contains(type.getJavaType());
    }

    public static FunctionInfo operatorInfo(OperatorType operatorType, String returnType, List<String> argumentTypes, MethodHandle method, boolean nullable, List<Boolean> nullableArguments) {
        operatorType.validateSignature(returnType, (List<String>)ImmutableList.copyOf(argumentTypes));
        Signature signature = Signature.internalOperator(operatorType.name(), returnType, argumentTypes);
        return new FunctionInfo(signature, operatorType.getOperator(), true, method, true, nullable, nullableArguments);
    }

    public static String mangleOperatorName(OperatorType operatorType) {
        return FunctionRegistry.mangleOperatorName(operatorType.name());
    }

    public static String mangleOperatorName(String operatorName) {
        return OPERATOR_PREFIX + operatorName;
    }

    @VisibleForTesting
    public static OperatorType unmangleOperator(String mangledName) {
        Preconditions.checkArgument((boolean)mangledName.startsWith(OPERATOR_PREFIX), (String)"%s is not a mangled operator name", (Object[])new Object[]{mangledName});
        return OperatorType.valueOf(mangledName.substring(OPERATOR_PREFIX.length()));
    }

    private static class FunctionMap {
        private final Multimap<QualifiedName, ParametricFunction> functions;

        public FunctionMap() {
            this.functions = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Iterable<? extends ParametricFunction> functions) {
            this.functions = ImmutableListMultimap.builder().putAll(map.functions).putAll((Multimap)Multimaps.index(functions, (Function)new Function<ParametricFunction, QualifiedName>(){

                public QualifiedName apply(ParametricFunction input) {
                    return QualifiedName.of((String)input.getSignature().getName(), (String[])new String[0]);
                }
            })).build();
            for (Map.Entry entry : this.functions.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                Preconditions.checkState((Iterables.all((Iterable)values, ParametricFunctionUtils.isAggregationPredicate()) || !Iterables.any((Iterable)values, ParametricFunctionUtils.isAggregationPredicate()) ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", (Object[])new Object[]{entry.getKey()});
            }
        }

        public List<ParametricFunction> list() {
            return ImmutableList.copyOf((Collection)this.functions.values());
        }

        public Collection<ParametricFunction> get(QualifiedName name) {
            return this.functions.get((Object)name);
        }
    }
}

