/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.NodeVersion;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.spi.Node;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceType;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class DiscoveryNodeManager
implements InternalNodeManager {
    private static final Duration MAX_AGE = new Duration(5.0, TimeUnit.SECONDS);
    private static final Splitter DATASOURCES_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final ServiceSelector serviceSelector;
    private final NodeInfo nodeInfo;
    private final FailureDetector failureDetector;
    private final NodeVersion expectedNodeVersion;
    @GuardedBy(value="this")
    private SetMultimap<String, Node> activeNodesByDataSource;
    @GuardedBy(value="this")
    private AllNodes allNodes;
    @GuardedBy(value="this")
    private long lastUpdateTimestamp;
    @GuardedBy(value="this")
    private PrestoNode currentNode;

    @Inject
    public DiscoveryNodeManager(@ServiceType(value="presto") ServiceSelector serviceSelector, NodeInfo nodeInfo, FailureDetector failureDetector, NodeVersion expectedNodeVersion) {
        this.serviceSelector = (ServiceSelector)Preconditions.checkNotNull((Object)serviceSelector, (Object)"serviceSelector is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.failureDetector = (FailureDetector)Preconditions.checkNotNull((Object)failureDetector, (Object)"failureDetector is null");
        this.expectedNodeVersion = (NodeVersion)Preconditions.checkNotNull((Object)expectedNodeVersion, (Object)"expectedNodeVersion is null");
        this.refreshNodes();
    }

    @Override
    public synchronized void refreshNodes() {
        this.lastUpdateTimestamp = System.nanoTime();
        Set services = IterableTransformer.on(this.serviceSelector.selectAllServices()).select(Predicates.not((Predicate)Predicates.in(this.failureDetector.getFailed()))).set();
        this.currentNode = null;
        ImmutableSet.Builder activeNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder inactiveNodesBuilder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder byDataSourceBuilder = ImmutableSetMultimap.builder();
        for (ServiceDescriptor service : services) {
            URI uri = DiscoveryNodeManager.getHttpUri(service);
            NodeVersion nodeVersion = DiscoveryNodeManager.getNodeVersion(service);
            if (uri == null || nodeVersion == null) continue;
            PrestoNode node = new PrestoNode(service.getNodeId(), uri, nodeVersion);
            if (node.getNodeIdentifier().equals(this.nodeInfo.getNodeId())) {
                this.currentNode = node;
                Preconditions.checkState((boolean)this.currentNode.getNodeVersion().equals(this.expectedNodeVersion), (Object)"INVARIANT: current node version should be equal to expected node version");
            }
            if (this.isActive(node)) {
                activeNodesBuilder.add((Object)node);
                String dataSources = (String)service.getProperties().get("datasources");
                if (dataSources != null) {
                    dataSources = dataSources.toLowerCase();
                    for (String dataSource : DATASOURCES_SPLITTER.split((CharSequence)dataSources)) {
                        byDataSourceBuilder.put((Object)dataSource, (Object)node);
                    }
                }
                byDataSourceBuilder.put((Object)"system", (Object)node);
                continue;
            }
            inactiveNodesBuilder.add((Object)node);
        }
        this.allNodes = new AllNodes((Set<Node>)activeNodesBuilder.build(), (Set<Node>)inactiveNodesBuilder.build());
        this.activeNodesByDataSource = byDataSourceBuilder.build();
        Preconditions.checkState((this.currentNode != null ? 1 : 0) != 0, (Object)"INVARIANT: current node not returned from service selector");
    }

    private synchronized void refreshIfNecessary() {
        if (Duration.nanosSince((long)this.lastUpdateTimestamp).compareTo(MAX_AGE) > 0) {
            this.refreshNodes();
        }
    }

    private boolean isActive(PrestoNode node) {
        return this.expectedNodeVersion.equals(node.getNodeVersion());
    }

    @Override
    public synchronized AllNodes getAllNodes() {
        this.refreshIfNecessary();
        return this.allNodes;
    }

    public Set<Node> getActiveNodes() {
        return this.getAllNodes().getActiveNodes();
    }

    public synchronized Set<Node> getActiveDatasourceNodes(String datasourceName) {
        this.refreshIfNecessary();
        return this.activeNodesByDataSource.get((Object)datasourceName);
    }

    public synchronized Node getCurrentNode() {
        this.refreshIfNecessary();
        return this.currentNode;
    }

    private static URI getHttpUri(ServiceDescriptor descriptor) {
        for (String type : Arrays.asList("https", "http")) {
            String url = (String)descriptor.getProperties().get(type);
            if (url == null) continue;
            try {
                return new URI(url);
            }
            catch (URISyntaxException ignored) {
            }
        }
        return null;
    }

    private static NodeVersion getNodeVersion(ServiceDescriptor descriptor) {
        String nodeVersion = (String)descriptor.getProperties().get("node_version");
        return nodeVersion == null ? null : new NodeVersion(nodeVersion);
    }
}

