/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.StageId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;

public class TaskId {
    private final StageId stageId;
    private final String id;

    @JsonCreator
    public static TaskId valueOf(String taskId) {
        List<String> ids = QueryId.parseDottedId(taskId, 3, "taskId");
        return new TaskId(new StageId(new QueryId(ids.get(0)), ids.get(1)), ids.get(2));
    }

    public TaskId(String queryId, String stageId, String id) {
        this.stageId = new StageId(queryId, stageId);
        this.id = QueryId.validateId(id);
    }

    public TaskId(StageId stageId, String id) {
        this.stageId = (StageId)Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        this.id = QueryId.validateId(id);
    }

    public QueryId getQueryId() {
        return this.stageId.getQueryId();
    }

    public StageId getStageId() {
        return this.stageId;
    }

    public String getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.stageId + "." + this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stageId, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskId other = (TaskId)obj;
        return Objects.equal((Object)this.stageId, (Object)other.stageId) && Objects.equal((Object)this.id, (Object)other.id);
    }
}

