/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.base.Predicate;

public enum StageState {
    PLANNED(false),
    SCHEDULING(false),
    SCHEDULED(false),
    RUNNING(false),
    FINISHED(true),
    CANCELED(true),
    FAILED(true);

    private final boolean doneState;

    private StageState(boolean doneState) {
        this.doneState = doneState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public static Predicate<StageState> inDoneState() {
        return new Predicate<StageState>(){

            public boolean apply(StageState state) {
                return state.isDone();
            }
        };
    }
}

