/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;

public class StageId {
    private final QueryId queryId;
    private final String id;

    @JsonCreator
    public static StageId valueOf(String stageId) {
        List<String> ids = QueryId.parseDottedId(stageId, 2, "stageId");
        return new StageId(new QueryId(ids.get(0)), ids.get(1));
    }

    public StageId(QueryId queryId, String id) {
        this.queryId = (QueryId)Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        this.id = QueryId.validateId(id);
    }

    public StageId(String queryId, String id) {
        this.queryId = new QueryId(queryId);
        this.id = QueryId.validateId(id);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public String getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.queryId + "." + this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.queryId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StageId other = (StageId)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.queryId, (Object)other.queryId);
    }
}

