/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final QueryMonitor queryMonitor;
    private final DataSize maxTaskMemoryUsage;
    private final DataSize operatorPreAllocatedMemory;
    private final boolean cpuTimerEnabled;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, QueryMonitor queryMonitor, TaskManagerConfig config) {
        this(taskNotificationExecutor, taskExecutor, planner, queryMonitor, config.getMaxTaskMemoryUsage(), config.getOperatorPreAllocatedMemory(), config.isTaskCpuTimerEnabled());
    }

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, QueryMonitor queryMonitor, DataSize maxTaskMemoryUsage, DataSize operatorPreAllocatedMemory, boolean cpuTimerEnabled) {
        this.taskNotificationExecutor = (Executor)Preconditions.checkNotNull((Object)taskNotificationExecutor, (Object)"taskNotificationExecutor is null");
        this.taskExecutor = (TaskExecutor)Preconditions.checkNotNull((Object)taskExecutor, (Object)"taskExecutor is null");
        this.planner = (LocalExecutionPlanner)Preconditions.checkNotNull((Object)planner, (Object)"planner is null");
        this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
        this.maxTaskMemoryUsage = (DataSize)Preconditions.checkNotNull((Object)maxTaskMemoryUsage, (Object)"maxTaskMemoryUsage is null");
        this.operatorPreAllocatedMemory = (DataSize)Preconditions.checkNotNull((Object)operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null");
        this.cpuTimerEnabled = (Boolean)Preconditions.checkNotNull((Object)cpuTimerEnabled, (Object)"cpuTimerEnabled is null");
    }

    public SqlTaskExecution create(ConnectorSession session, TaskStateMachine taskStateMachine, SharedBuffer sharedBuffer, PlanFragment fragment, List<TaskSource> sources) {
        TaskContext taskContext = new TaskContext(taskStateMachine, this.taskNotificationExecutor, session, (DataSize)Preconditions.checkNotNull((Object)this.maxTaskMemoryUsage, (Object)"maxTaskMemoryUsage is null"), (DataSize)Preconditions.checkNotNull((Object)this.operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null"), this.cpuTimerEnabled);
        return SqlTaskExecution.createSqlTaskExecution(taskStateMachine, taskContext, sharedBuffer, fragment, sources, this.planner, this.taskExecutor, this.taskNotificationExecutor, this.queryMonitor);
    }
}

