/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.TaskSource;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.SqlTaskIoStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.SetThreadName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class SqlTask {
    private static final Logger log = Logger.get(SqlTask.class);
    private final TaskId taskId;
    private final URI location;
    private final TaskStateMachine taskStateMachine;
    private final SharedBuffer sharedBuffer;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
    private final AtomicReference<TaskHolder> taskHolderReference = new AtomicReference<TaskHolder>(new TaskHolder());

    public SqlTask(TaskId taskId, URI location, SqlTaskExecutionFactory sqlTaskExecutionFactory, ExecutorService taskNotificationExecutor, final Function<SqlTask, ?> onDone, DataSize maxBufferSize) {
        this.taskId = (TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location is null");
        this.sqlTaskExecutionFactory = (SqlTaskExecutionFactory)Preconditions.checkNotNull((Object)sqlTaskExecutionFactory, (Object)"sqlTaskExecutionFactory is null");
        Preconditions.checkNotNull((Object)taskNotificationExecutor, (Object)"taskNotificationExecutor is null");
        Preconditions.checkNotNull(onDone, (Object)"onDone is null");
        Preconditions.checkNotNull((Object)maxBufferSize, (Object)"maxBufferSize is null");
        this.sharedBuffer = new SharedBuffer(taskId, taskNotificationExecutor, maxBufferSize);
        this.taskStateMachine = new TaskStateMachine(taskId, taskNotificationExecutor);
        this.taskStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

            @Override
            public void stateChanged(TaskState taskState) {
                TaskHolder taskHolder;
                if (!taskState.isDone()) {
                    return;
                }
                do {
                    if (!(taskHolder = (TaskHolder)SqlTask.this.taskHolderReference.get()).isFinished()) continue;
                    return;
                } while (!SqlTask.this.taskHolderReference.compareAndSet(taskHolder, new TaskHolder(SqlTask.this.createTaskInfo(taskHolder), taskHolder.getIoStats())));
                if (taskState != TaskState.FAILED) {
                    SqlTask.this.sharedBuffer.destroy();
                }
                try {
                    onDone.apply((Object)SqlTask.this);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Error running task cleanup callback %s", new Object[]{SqlTask.this.taskId});
                }
            }
        });
    }

    public SqlTaskIoStats getIoStats() {
        return this.taskHolderReference.get().getIoStats();
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public TaskInfo getTaskInfo() {
        this.lastHeartbeat.set(DateTime.now());
        try (SetThreadName ignored = new SetThreadName("Task-%s", this.taskId);){
            TaskInfo taskInfo = this.createTaskInfo(this.taskHolderReference.get());
            return taskInfo;
        }
    }

    private TaskInfo createTaskInfo(TaskHolder taskHolder) {
        ImmutableSet noMoreSplits;
        TaskStats taskStats;
        SqlTaskExecution taskExecution;
        TaskInfo finalTaskInfo = taskHolder.getFinalTaskInfo();
        if (finalTaskInfo != null) {
            return finalTaskInfo;
        }
        TaskState state = this.taskStateMachine.getState();
        Object failures = ImmutableList.of();
        if (state == TaskState.FAILED) {
            failures = Failures.toFailures(this.taskStateMachine.getFailureCauses());
        }
        if ((taskExecution = taskHolder.getTaskExecution()) != null) {
            taskStats = taskExecution.getTaskContext().getTaskStats();
            noMoreSplits = taskExecution.getNoMoreSplits();
        } else {
            taskStats = new TaskStats(this.taskStateMachine.getCreatedTime());
            noMoreSplits = ImmutableSet.of();
        }
        return new TaskInfo(this.taskStateMachine.getTaskId(), this.nextTaskInfoVersion.getAndIncrement(), state, this.location, this.lastHeartbeat.get(), this.sharedBuffer.getInfo(), (Set<PlanNodeId>)noMoreSplits, taskStats, (List<ExecutionFailureInfo>)failures);
    }

    public ListenableFuture<TaskInfo> getTaskInfo(TaskState callersCurrentState) {
        Preconditions.checkNotNull((Object)((Object)callersCurrentState), (Object)"callersCurrentState is null");
        this.lastHeartbeat.set(DateTime.now());
        if (callersCurrentState.isDone()) {
            return Futures.immediateFuture((Object)this.getTaskInfo());
        }
        ListenableFuture<TaskState> futureTaskState = this.taskStateMachine.getStateChange(callersCurrentState);
        return Futures.transform(futureTaskState, (Function)new Function<TaskState, TaskInfo>(){

            @Nullable
            public TaskInfo apply(@Nullable TaskState state) {
                return SqlTask.this.getTaskInfo();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo updateTask(ConnectorSession session, PlanFragment fragment, List<TaskSource> sources, OutputBuffers outputBuffers) {
        SqlTaskExecution taskExecution;
        SqlTask sqlTask = this;
        synchronized (sqlTask) {
            TaskHolder taskHolder = this.taskHolderReference.get();
            if (taskHolder.isFinished()) {
                return taskHolder.getFinalTaskInfo();
            }
            taskExecution = taskHolder.getTaskExecution();
            if (taskExecution == null) {
                taskExecution = this.sqlTaskExecutionFactory.create(session, this.taskStateMachine, this.sharedBuffer, fragment, sources);
                this.taskHolderReference.compareAndSet(taskHolder, new TaskHolder(taskExecution));
            }
        }
        this.lastHeartbeat.set(DateTime.now());
        this.sharedBuffer.setOutputBuffers(outputBuffers);
        taskExecution.addSources(sources);
        return this.getTaskInfo();
    }

    public ListenableFuture<BufferResult> getTaskResults(String outputName, long startingSequenceId, DataSize maxSize) {
        Preconditions.checkNotNull((Object)outputName, (Object)"outputName is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        this.lastHeartbeat.set(DateTime.now());
        return this.sharedBuffer.get(outputName, startingSequenceId, maxSize);
    }

    public TaskInfo abortTaskResults(String outputId) {
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        this.lastHeartbeat.set(DateTime.now());
        log.debug("Aborting task %s output %s", new Object[]{this.taskId, outputId});
        this.sharedBuffer.abort(outputId);
        return this.getTaskInfo();
    }

    public void failed(Throwable cause) {
        Preconditions.checkNotNull((Object)cause, (Object)"cause is null");
        this.taskStateMachine.failed(cause);
    }

    public TaskInfo cancel() {
        this.lastHeartbeat.set(DateTime.now());
        this.taskStateMachine.cancel();
        return this.getTaskInfo();
    }

    public String toString() {
        return this.taskId.toString();
    }

    public static Function<SqlTask, TaskInfo> taskInfoGetter() {
        return new Function<SqlTask, TaskInfo>(){

            @Nullable
            public TaskInfo apply(SqlTask sqlTask) {
                return sqlTask.getTaskInfo();
            }
        };
    }

    private static final class TaskHolder {
        private final SqlTaskExecution taskExecution;
        private final TaskInfo finalTaskInfo;
        private final SqlTaskIoStats finalIoStats;

        private TaskHolder() {
            this.taskExecution = null;
            this.finalTaskInfo = null;
            this.finalIoStats = null;
        }

        private TaskHolder(SqlTaskExecution taskExecution) {
            this.taskExecution = (SqlTaskExecution)Preconditions.checkNotNull((Object)taskExecution, (Object)"taskExecution is null");
            this.finalTaskInfo = null;
            this.finalIoStats = null;
        }

        private TaskHolder(TaskInfo finalTaskInfo, SqlTaskIoStats finalIoStats) {
            this.taskExecution = null;
            this.finalTaskInfo = (TaskInfo)Preconditions.checkNotNull((Object)finalTaskInfo, (Object)"finalTaskInfo is null");
            this.finalIoStats = (SqlTaskIoStats)Preconditions.checkNotNull((Object)finalIoStats, (Object)"finalIoStats is null");
        }

        public boolean isFinished() {
            return this.finalTaskInfo != null;
        }

        @Nullable
        public SqlTaskExecution getTaskExecution() {
            return this.taskExecution;
        }

        @Nullable
        public TaskInfo getFinalTaskInfo() {
            return this.finalTaskInfo;
        }

        public SqlTaskIoStats getIoStats() {
            if (this.finalIoStats != null) {
                return this.finalIoStats;
            }
            if (this.taskExecution == null) {
                return new SqlTaskIoStats();
            }
            TaskContext taskContext = this.taskExecution.getTaskContext();
            return new SqlTaskIoStats(taskContext.getInputDataSize(), taskContext.getInputPositions(), taskContext.getOutputDataSize(), taskContext.getOutputPositions());
        }
    }
}

