/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QueryId {
    private final String id;
    static final Pattern ID_PATTERN = Pattern.compile("[_a-z0-9]+");

    @JsonCreator
    public static QueryId valueOf(String queryId) {
        List<String> ids = QueryId.parseDottedId(queryId, 1, "queryId");
        return new QueryId(ids.get(0));
    }

    public QueryId(String id) {
        this.id = QueryId.validateId(id);
    }

    public String getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryId other = (QueryId)obj;
        return Objects.equal((Object)this.id, (Object)other.id);
    }

    static String validateId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id is empty");
        Preconditions.checkArgument((boolean)ID_PATTERN.matcher(id).matches(), (String)"Invalid id %s", (Object[])new Object[]{id});
        return id;
    }

    static List<String> parseDottedId(String id, int expectedParts, String name) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        Preconditions.checkArgument((expectedParts > 0 ? 1 : 0) != 0, (Object)"expectedParts must be at least 1");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)id));
        Preconditions.checkArgument((ids.size() == expectedParts ? 1 : 0) != 0, (String)"Invalid %s %s", (Object[])new Object[]{name, id});
        for (String part : ids) {
            Preconditions.checkArgument((!part.isEmpty() ? 1 : 0) != 0, (String)"Invalid id %s", (Object[])new Object[]{id});
            Preconditions.checkArgument((boolean)ID_PATTERN.matcher(part).matches(), (String)"Invalid id %s", (Object[])new Object[]{id});
        }
        return ids;
    }
}

