/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.NodeSchedulerConfig;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class NodeScheduler {
    private final NodeManager nodeManager;
    private final AtomicLong scheduleLocal = new AtomicLong();
    private final AtomicLong scheduleRack = new AtomicLong();
    private final AtomicLong scheduleRandom = new AtomicLong();
    private final int minCandidates;
    private final boolean locationAwareScheduling;
    private final boolean includeCoordinator;
    private final int maxSplitsPerNode;
    private final int maxSplitsPerNodePerTaskWhenFull;
    private final NodeTaskMap nodeTaskMap;
    private final boolean doubleScheduling;

    @Inject
    public NodeScheduler(NodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        this.nodeManager = nodeManager;
        this.minCandidates = config.getMinCandidates();
        this.locationAwareScheduling = config.isLocationAwareSchedulingEnabled();
        this.includeCoordinator = config.isIncludeCoordinator();
        this.doubleScheduling = config.isMultipleTasksPerNodeEnabled();
        this.maxSplitsPerNode = config.getMaxSplitsPerNode();
        this.maxSplitsPerNodePerTaskWhenFull = config.getMaxPendingSplitsPerNodePerTask();
        this.nodeTaskMap = (NodeTaskMap)Preconditions.checkNotNull((Object)nodeTaskMap, (Object)"nodeTaskMap is null");
        Preconditions.checkArgument((this.maxSplitsPerNode > this.maxSplitsPerNodePerTaskWhenFull ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxSplitsPerNodePerTaskWhenFull");
    }

    @Managed
    public long getScheduleLocal() {
        return this.scheduleLocal.get();
    }

    @Managed
    public long getScheduleRack() {
        return this.scheduleRack.get();
    }

    @Managed
    public long getScheduleRandom() {
        return this.scheduleRandom.get();
    }

    @Managed
    public void reset() {
        this.scheduleLocal.set(0L);
        this.scheduleRack.set(0L);
        this.scheduleRandom.set(0L);
    }

    public NodeSelector createNodeSelector(final String dataSourceName, Map<Node, RemoteTask> taskMap) {
        Supplier nodeMap = Suppliers.memoizeWithExpiration((Supplier)new Supplier<NodeMap>(){

            public NodeMap get() {
                ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
                ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
                ImmutableSetMultimap.Builder byRack = ImmutableSetMultimap.builder();
                Set nodes = dataSourceName != null ? NodeScheduler.this.nodeManager.getActiveDatasourceNodes(dataSourceName) : FluentIterable.from((Iterable)NodeScheduler.this.nodeManager.getActiveNodes()).filter((Predicate)new Predicate<Node>(){

                    public boolean apply(Node node) {
                        return NodeScheduler.this.includeCoordinator || !NodeScheduler.this.nodeManager.getCurrentNode().getNodeIdentifier().equals(node.getNodeIdentifier());
                    }
                }).toSet();
                for (Node node : nodes) {
                    try {
                        byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                        InetAddress host = InetAddress.getByName(node.getHttpUri().getHost());
                        byHost.put((Object)host, (Object)node);
                        byRack.put((Object)Rack.of(host), (Object)node);
                    }
                    catch (UnknownHostException e) {}
                }
                return new NodeMap((SetMultimap<HostAddress, Node>)byHostAndPort.build(), (SetMultimap<InetAddress, Node>)byHost.build(), (SetMultimap<Rack, Node>)byRack.build());
            }
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        return new NodeSelector((Supplier<NodeMap>)nodeMap, taskMap);
    }

    private static <T> Iterable<T> lazyShuffle(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    List<T> list;
                    int limit;
                    {
                        this.list = Lists.newArrayList((Iterable)iterable);
                        this.limit = this.list.size();
                    }

                    protected T computeNext() {
                        if (this.limit == 0) {
                            return this.endOfData();
                        }
                        int position = ThreadLocalRandom.current().nextInt(this.limit);
                        Object result = this.list.get(position);
                        this.list.set(position, this.list.get(this.limit - 1));
                        --this.limit;
                        return result;
                    }
                };
            }
        };
    }

    private static class Rack {
        private int id;

        public static Rack of(InetAddress address) {
            int id = InetAddresses.coerceToInteger((InetAddress)address) & 0xFFFFFF00;
            return new Rack(id);
        }

        private Rack(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rack rack = (Rack)o;
            return this.id == rack.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class NodeMap {
        private final SetMultimap<HostAddress, Node> nodesByHostAndPort;
        private final SetMultimap<InetAddress, Node> nodesByHost;
        private final SetMultimap<Rack, Node> nodesByRack;

        public NodeMap(SetMultimap<HostAddress, Node> nodesByHostAndPort, SetMultimap<InetAddress, Node> nodesByHost, SetMultimap<Rack, Node> nodesByRack) {
            this.nodesByHostAndPort = nodesByHostAndPort;
            this.nodesByHost = nodesByHost;
            this.nodesByRack = nodesByRack;
        }

        private SetMultimap<HostAddress, Node> getNodesByHostAndPort() {
            return this.nodesByHostAndPort;
        }

        public SetMultimap<InetAddress, Node> getNodesByHost() {
            return this.nodesByHost;
        }

        public SetMultimap<Rack, Node> getNodesByRack() {
            return this.nodesByRack;
        }
    }

    public class NodeSelector {
        private final AtomicReference<Supplier<NodeMap>> nodeMap;
        private final Map<Node, RemoteTask> taskMap;

        public NodeSelector(Supplier<NodeMap> nodeMap, Map<Node, RemoteTask> taskMap) {
            this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
            this.taskMap = taskMap;
        }

        public void lockDownNodes() {
            this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
        }

        public List<Node> allNodes() {
            return ImmutableList.copyOf((Collection)((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
        }

        public Node selectCurrentNode() {
            return NodeScheduler.this.nodeManager.getCurrentNode();
        }

        public List<Node> selectRandomNodes(int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be at least 1");
            FluentIterable nodes = FluentIterable.from((Iterable)NodeScheduler.lazyShuffle(((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values()));
            if (NodeScheduler.this.doubleScheduling) {
                nodes = nodes.cycle();
            }
            return nodes.limit(limit).toList();
        }

        public Multimap<Node, Split> computeAssignments(Set<Split> splits) {
            HashMultimap assignment = HashMultimap.create();
            HashMap<Node, Integer> assignmentCount = new HashMap<Node, Integer>();
            HashMap<Node, Integer> splitCountByNode = new HashMap<Node, Integer>();
            for (Split split : splits) {
                int assignedSplitCount;
                List<Node> candidateNodes = NodeScheduler.this.locationAwareScheduling ? this.selectCandidateNodes((NodeMap)this.nodeMap.get().get(), split) : this.selectRandomNodes(NodeScheduler.this.minCandidates);
                Failures.checkCondition(!candidateNodes.isEmpty(), StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query", new Object[0]);
                for (Node node : candidateNodes) {
                    if (splitCountByNode.containsKey(node)) continue;
                    splitCountByNode.put(node, NodeScheduler.this.nodeTaskMap.getPartitionedSplitsOnNode(node));
                }
                Node chosenNode = null;
                int min = Integer.MAX_VALUE;
                for (Node node : candidateNodes) {
                    assignedSplitCount = assignmentCount.containsKey(node) ? (Integer)assignmentCount.get(node) : 0;
                    int totalSplitCount = assignedSplitCount + (Integer)splitCountByNode.get(node);
                    if (totalSplitCount >= min || totalSplitCount >= NodeScheduler.this.maxSplitsPerNode) continue;
                    chosenNode = node;
                    min = totalSplitCount;
                }
                if (chosenNode == null) {
                    for (Node node : candidateNodes) {
                        assignedSplitCount = assignmentCount.containsKey(node) ? (Integer)assignmentCount.get(node) : 0;
                        RemoteTask remoteTask = this.taskMap.get(node);
                        int queuedSplitCount = remoteTask == null ? 0 : remoteTask.getQueuedPartitionedSplitCount();
                        int totalSplitCount = queuedSplitCount + assignedSplitCount;
                        if (totalSplitCount >= min || totalSplitCount >= NodeScheduler.this.maxSplitsPerNodePerTaskWhenFull) continue;
                        chosenNode = node;
                        min = totalSplitCount;
                    }
                }
                if (chosenNode == null) continue;
                assignment.put(chosenNode, (Object)split);
                int count = assignmentCount.containsKey(chosenNode) ? (Integer)assignmentCount.get(chosenNode) : 0;
                assignmentCount.put(chosenNode, count + 1);
            }
            return assignment;
        }

        private List<Node> selectCandidateNodes(NodeMap nodeMap, Split split) {
            InetAddress address;
            LinkedHashSet<Node> chosen = new LinkedHashSet<Node>(NodeScheduler.this.minCandidates);
            for (HostAddress hint : split.getAddresses()) {
                for (Node node : nodeMap.getNodesByHostAndPort().get((Object)hint)) {
                    if (!chosen.add(node)) continue;
                    NodeScheduler.this.scheduleLocal.incrementAndGet();
                }
                try {
                    address = hint.toInetAddress();
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (hint.hasPort() && !split.isRemotelyAccessible()) continue;
                for (Node node : nodeMap.getNodesByHost().get((Object)address)) {
                    if (!chosen.add(node)) continue;
                    NodeScheduler.this.scheduleLocal.incrementAndGet();
                }
            }
            if (split.isRemotelyAccessible() && chosen.size() < NodeScheduler.this.minCandidates) {
                for (HostAddress hint : split.getAddresses()) {
                    try {
                        address = hint.toInetAddress();
                    }
                    catch (UnknownHostException e) {
                        continue;
                    }
                    for (Node node : nodeMap.getNodesByRack().get((Object)Rack.of(address))) {
                        if (chosen.add(node)) {
                            NodeScheduler.this.scheduleRack.incrementAndGet();
                        }
                        if (chosen.size() != NodeScheduler.this.minCandidates) continue;
                        break;
                    }
                    if (chosen.size() != NodeScheduler.this.minCandidates) continue;
                    break;
                }
            }
            if (split.isRemotelyAccessible() && chosen.size() < NodeScheduler.this.minCandidates) {
                for (Node node : NodeScheduler.lazyShuffle(nodeMap.getNodesByHost().values())) {
                    if (chosen.add(node)) {
                        NodeScheduler.this.scheduleRandom.incrementAndGet();
                    }
                    if (chosen.size() != NodeScheduler.this.minCandidates) continue;
                    break;
                }
            }
            return ImmutableList.copyOf(chosen);
        }
    }
}

