/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.operator.Page;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class BufferResult {
    private final long token;
    private final long nextToken;
    private final boolean bufferClosed;
    private final List<Page> pages;
    private final PagePartitionFunction partitionFunction;

    public static BufferResult emptyResults(long token, boolean bufferClosed) {
        return new BufferResult(token, token, bufferClosed, (List<Page>)ImmutableList.of(), new UnpartitionedPagePartitionFunction());
    }

    public BufferResult(long token, long nextToken, boolean bufferClosed, List<Page> pages) {
        this(token, nextToken, bufferClosed, pages, new UnpartitionedPagePartitionFunction());
    }

    public BufferResult(long token, long nextToken, boolean bufferClosed, List<Page> pages, PagePartitionFunction partitionFunction) {
        this.token = token;
        this.nextToken = nextToken;
        this.bufferClosed = bufferClosed;
        this.pages = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(pages, (Object)"pages is null")));
        this.partitionFunction = partitionFunction;
    }

    public long getToken() {
        return this.token;
    }

    public long getNextToken() {
        return this.nextToken;
    }

    public boolean isBufferClosed() {
        return this.bufferClosed;
    }

    public List<Page> getPages() {
        return this.partitionFunction.partition(this.pages);
    }

    public int size() {
        return this.pages.size();
    }

    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.token, this.nextToken, this.bufferClosed, this.pages, this.partitionFunction});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BufferResult other = (BufferResult)obj;
        return Objects.equal((Object)this.token, (Object)other.token) && Objects.equal((Object)this.nextToken, (Object)other.nextToken) && Objects.equal((Object)this.bufferClosed, (Object)other.bufferClosed) && Objects.equal(this.pages, other.pages) && Objects.equal((Object)this.partitionFunction, (Object)other.partitionFunction);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("bufferClosed", this.bufferClosed).add("pages", this.pages).add("partitionFunction", (Object)this.partitionFunction).toString();
    }
}

